/**
  **************************************************************************************
  * @file    REG_BS16T.h
  * @brief   BS16T Head File
  *
  * @version V0.01
  * @data    3/8/2021
  * @author  Eastsoft MCU Software Team
  * @note
  *
  * Copyright (C) 2018 Shanghai Eastsoft Microelectronics Co., Ltd. ALL rights reserved.
  *
  **************************************************************************************
  */

#ifndef __REG_BS16T_H__
#define __REG_BS16T_H__


/******************************************************************************/
/*                              设备特殊寄存器结构定义                        */
/******************************************************************************/

/*   允许匿名结构和匿名联合    */
#pragma anon_unions

/****************** Bit definition for BS16T_CON1 register ************************/

#define	BS16T_CON1_APREN_POS	7U 
#define	BS16T_CON1_APREN_MSK	BIT(BS16T_CON1_APREN_POS)

#define	BS16T_CON1_SPMEN_POS	3U 
#define	BS16T_CON1_SPMEN_MSK	BIT(BS16T_CON1_SPMEN_POS)

#define	BS16T_CON1_UERSEL_POS	2U 
#define	BS16T_CON1_UERSEL_MSK	BIT(BS16T_CON1_UERSEL_POS)

#define	BS16T_CON1_DISUE_POS	1U 
#define	BS16T_CON1_DISUE_MSK	BIT(BS16T_CON1_DISUE_POS)

#define	BS16T_CON1_CNTEN_POS	0U 
#define	BS16T_CON1_CNTEN_MSK	BIT(BS16T_CON1_CNTEN_POS)

/****************** Bit definition for BS16T_IER register ************************/

#define	BS16T_IER_UIT_POS	0U 
#define	BS16T_IER_UIT_MSK	BIT(BS16T_IER_UIT_POS)

/****************** Bit definition for BS16T_IDR register ************************/

#define	BS16T_IDR_UI_POS	0U 
#define	BS16T_IDR_UI_MSK	BIT(BS16T_IDR_UI_POS)

/****************** Bit definition for BS16T_IVS register ************************/

#define	BS16T_IVS_UEI_POS	0U 
#define	BS16T_IVS_UEI_MSK	BIT(BS16T_IVS_UEI_POS)

/****************** Bit definition for BS16T_RIF register ************************/

#define	BS16T_RIF_UEVTIF_POS	0U 
#define	BS16T_RIF_UEVTIF_MSK	BIT(BS16T_RIF_UEVTIF_POS)

/****************** Bit definition for BS16T_IFM register ************************/

#define	BS16T_IFM_UEI_POS	0U 
#define	BS16T_IFM_UEI_MSK	BIT(BS16T_IFM_UEI_POS)

/****************** Bit definition for BS16T_ICR register ************************/

#define	BS16T_ICR_UEIC_POS	0U 
#define	BS16T_ICR_UEIC_MSK	BIT(BS16T_ICR_UEIC_POS)

/****************** Bit definition for BS16T_SGE register ************************/

#define	BS16T_SGE_SGU_POS	0U 
#define	BS16T_SGE_SGU_MSK	BIT(BS16T_SGE_SGU_POS)

/****************** Bit definition for BS16T_COUNT register ************************/

#define	BS16T_COUNT_CNTV_POSS	0U 
#define	BS16T_COUNT_CNTV_POSE	15U 
#define	BS16T_COUNT_CNTV_MSK	BITS(BS16T_COUNT_CNTV_POSS,BS16T_COUNT_CNTV_POSE)

/****************** Bit definition for BS16T_PRES register ************************/

#define	BS16T_PRES_PSCV_POSS	0U 
#define	BS16T_PRES_PSCV_POSE	15U 
#define	BS16T_PRES_PSCV_MSK	BITS(BS16T_PRES_PSCV_POSS,BS16T_PRES_PSCV_POSE)

/****************** Bit definition for BS16T_AR register ************************/

#define	BS16T_AR_ARRV_POSS	0U 
#define	BS16T_AR_ARRV_POSE	15U 
#define	BS16T_AR_ARRV_MSK	BITS(BS16T_AR_ARRV_POSS,BS16T_AR_ARRV_POSE)

/****************** Bit definition for BS16T_DMAEN register ************************/

#define	BS16T_DMAEN_UDEN_POS	0U 
#define	BS16T_DMAEN_UDEN_MSK	BIT(BS16T_DMAEN_UDEN_POS)

typedef struct
{
	__IO uint32_t CON1;
	uint32_t RESERVED0[2] ;
	__O uint32_t IER;
	__O uint32_t IDR;
	__I uint32_t IVS;
	__I uint32_t RIF;
	__I uint32_t IFM;
	__O uint32_t ICR;
	__O uint32_t SGE;
	uint32_t RESERVED1[3] ;
	__IO uint32_t COUNT;
	__IO uint32_t PRES;
	__IO uint32_t AR;
	uint32_t RESERVED2[6] ;
	__IO uint32_t DMAEN;
} BS16T_TypeDef;





#endif
