/**
  **************************************************************************************
  * @file    REG_DBG.h
  * @brief   DBG Head File
  *
  * @version V0.01
  * @data    3/8/2021
  * @author  Eastsoft MCU Software Team
  * @note
  *
  * Copyright (C) 2018 Shanghai Eastsoft Microelectronics Co., Ltd. ALL rights reserved.
  *
  **************************************************************************************
  */

#ifndef __REG_DBG_H__
#define __REG_DBG_H__


/******************************************************************************/
/*                              设备特殊寄存器结构定义                        */
/******************************************************************************/

/*   允许匿名结构和匿名联合    */
#pragma anon_unions

/****************** Bit definition for DBGC_IDCODE register ************************/

#define	DBGC_IDCODE_REV_ID_POSS	16U 
#define	DBGC_IDCODE_REV_ID_POSE	31U 
#define	DBGC_IDCODE_REV_ID_MSK	BITS(DBGC_IDCODE_REV_ID_POSS,DBGC_IDCODE_REV_ID_POSE)

#define	DBGC_IDCODE_CORE_ID_POSS	12U 
#define	DBGC_IDCODE_CORE_ID_POSE	15U 
#define	DBGC_IDCODE_CORE_ID_MSK	BITS(DBGC_IDCODE_CORE_ID_POSS,DBGC_IDCODE_CORE_ID_POSE)

#define	DBGC_IDCODE_DEV_ID_POSS	0U 
#define	DBGC_IDCODE_DEV_ID_POSE	11U 
#define	DBGC_IDCODE_DEV_ID_MSK	BITS(DBGC_IDCODE_DEV_ID_POSS,DBGC_IDCODE_DEV_ID_POSE)

/****************** Bit definition for DBGC_APB1FZ register ************************/

#define	DBGC_APB1FZ_GP16C2T2_STOP_POS	4U 
#define	DBGC_APB1FZ_GP16C2T2_STOP_MSK	BIT(DBGC_APB1FZ_GP16C2T2_STOP_POS)

#define	DBGC_APB1FZ_GP16C2T1_STOP_POS	3U 
#define	DBGC_APB1FZ_GP16C2T1_STOP_MSK	BIT(DBGC_APB1FZ_GP16C2T1_STOP_POS)

#define	DBGC_APB1FZ_GP16C2T0_STOP_POS	2U 
#define	DBGC_APB1FZ_GP16C2T0_STOP_MSK	BIT(DBGC_APB1FZ_GP16C2T0_STOP_POS)

#define	DBGC_APB1FZ_BS16T0_STOP_POS	1U 
#define	DBGC_APB1FZ_BS16T0_STOP_MSK	BIT(DBGC_APB1FZ_BS16T0_STOP_POS)

#define	DBGC_APB1FZ_AD16C4T0_STOP_POS	0U 
#define	DBGC_APB1FZ_AD16C4T0_STOP_MSK	BIT(DBGC_APB1FZ_AD16C4T0_STOP_POS)

/****************** Bit definition for DBGC_APB2FZ register ************************/

#define	DBGC_APB2FZ_WWDT_STOP_POS	9U 
#define	DBGC_APB2FZ_WWDT_STOP_MSK	BIT(DBGC_APB2FZ_WWDT_STOP_POS)

#define	DBGC_APB2FZ_IWDT_STOP_POS	8U 
#define	DBGC_APB2FZ_IWDT_STOP_MSK	BIT(DBGC_APB2FZ_IWDT_STOP_POS)

#define	DBGC_APB2FZ_I2C1_STOP_POS	1U 
#define	DBGC_APB2FZ_I2C1_STOP_MSK	BIT(DBGC_APB2FZ_I2C1_STOP_POS)

#define	DBGC_APB2FZ_I2C0_STOP_POS	0U 
#define	DBGC_APB2FZ_I2C0_STOP_MSK	BIT(DBGC_APB2FZ_I2C0_STOP_POS)

typedef struct
{
	__I uint32_t IDCODE;
	uint32_t RESERVED0 ;
	__IO uint32_t APB1FZ;
	__IO uint32_t APB2FZ;
} DBGC_TypeDef;





#endif
