/**
  **************************************************************************************
  * @file    REG_SYSCFG.h
  * @brief   SYSCFG Head File
  *
  * @version V0.01
  * @data    3/8/2021
  * @author  Eastsoft MCU Software Team
  * @note
  *
  * Copyright (C) 2018 Shanghai Eastsoft Microelectronics Co., Ltd. ALL rights reserved.
  *
  **************************************************************************************
  */

#ifndef __REG_SYSCFG_H__
#define __REG_SYSCFG_H__


/******************************************************************************/
/*                              设备特殊寄存器结构定义                        */
/******************************************************************************/

/*   允许匿名结构和匿名联合    */
#pragma anon_unions

/****************** Bit definition for SYSCFG_PROT register ************************/

#define	SYSCFG_PROT_KEY_POSS	1U 
#define	SYSCFG_PROT_KEY_POSE	31U 
#define	SYSCFG_PROT_KEY_MSK	BITS(SYSCFG_PROT_KEY_POSS,SYSCFG_PROT_KEY_POSE)

#define	SYSCFG_PROT_PROT_POS	0U 
#define	SYSCFG_PROT_PROT_MSK	BIT(SYSCFG_PROT_PROT_POS)

/****************** Bit definition for SYSCFG_MEMRMP register ************************/

#define	SYSCFG_MEMRMP_VTOEN_POS	16U 
#define	SYSCFG_MEMRMP_VTOEN_MSK	BIT(SYSCFG_MEMRMP_VTOEN_POS)

#define	SYSCFG_MEMRMP_BFRMPEN_POS	8U 
#define	SYSCFG_MEMRMP_BFRMPEN_MSK	BIT(SYSCFG_MEMRMP_BFRMPEN_POS)

/****************** Bit definition for SYSCFG_VTOR register ************************/

#define	SYSCFG_VTOR_VTO_POSS	0U 
#define	SYSCFG_VTOR_VTO_POSE	29U 
#define	SYSCFG_VTOR_VTO_MSK	BITS(SYSCFG_VTOR_VTO_POSS,SYSCFG_VTOR_VTO_POSE)

/****************** Bit definition for SYSCFG_TBKCFG register ************************/

#define	SYSCFG_TBKCFG_CLUBKE_POS	2U 
#define	SYSCFG_TBKCFG_CLUBKE_MSK	BIT(SYSCFG_TBKCFG_CLUBKE_POS)

#define	SYSCFG_TBKCFG_LVDBKE_POS	1U 
#define	SYSCFG_TBKCFG_LVDBKE_MSK	BIT(SYSCFG_TBKCFG_LVDBKE_POS)

#define	SYSCFG_TBKCFG_CCSBKE_POS	0U 
#define	SYSCFG_TBKCFG_CCSBKE_MSK	BIT(SYSCFG_TBKCFG_CCSBKE_POS)

typedef struct
{
	__IO uint32_t PROT;
	__IO uint32_t MEMRMP;
	__IO uint32_t VTOR;
	__IO uint32_t TBKCFG;
} SYSCFG_TypeDef;





#endif
