/**
  **************************************************************************************
  * @file    REG_CMU.h
  * @brief   CMU Head File
  *
  * @version V0.01
  * @data    8/24/2020
  * @author  Eastsoft MCU Software Team
  * @note
  *
  * Copyright (C) 2018 Shanghai Eastsoft Microelectronics Co., Ltd. ALL rights reserved.
  *
  **************************************************************************************
  */

#ifndef __CMU_H__
#define __CMU_H__


/******************************************************************************/
/*                              设备特殊寄存器结构定义                        */
/******************************************************************************/

/*   允许匿名结构和匿名联合    */
 

/****************** Bit definition for CMU_CSR register ************************/

#define	CMU_CSR_LSCK_STU_POSS	30U 
#define	CMU_CSR_LSCK_STU_POSE	31U 
#define	CMU_CSR_LSCK_STU_MSK	BITS(CMU_CSR_LSCK_STU_POSS,CMU_CSR_LSCK_STU_POSE)

#define	CMU_CSR_LSCK_CMD_POSS	28U 
#define	CMU_CSR_LSCK_CMD_POSE	29U 
#define	CMU_CSR_LSCK_CMD_MSK	BITS(CMU_CSR_LSCK_CMD_POSS,CMU_CSR_LSCK_CMD_POSE)

#define	CMU_CSR_CFT_RDYN_POS	25U 
#define	CMU_CSR_CFT_RDYN_MSK	BIT(CMU_CSR_CFT_RDYN_POS)

#define	CMU_CSR_CFT_STU_POS	24U 
#define	CMU_CSR_CFT_STU_MSK	BIT(CMU_CSR_CFT_STU_POS)

#define	CMU_CSR_CFT_CMD_POSS	16U 
#define	CMU_CSR_CFT_CMD_POSE	23U 
#define	CMU_CSR_CFT_CMD_MSK	BITS(CMU_CSR_CFT_CMD_POSS,CMU_CSR_CFT_CMD_POSE)

#define	CMU_CSR_LSCLK_RDYN_POS	13U 
#define	CMU_CSR_LSCLK_RDYN_MSK	BIT(CMU_CSR_LSCLK_RDYN_POS)

#define	CMU_CSR_SYS_RDYN_POS	12U 
#define	CMU_CSR_SYS_RDYN_MSK	BIT(CMU_CSR_SYS_RDYN_POS)

#define	CMU_CSR_SYS_STU_POSS	8U 
#define	CMU_CSR_SYS_STU_POSE	10U 
#define	CMU_CSR_SYS_STU_MSK	BITS(CMU_CSR_SYS_STU_POSS,CMU_CSR_SYS_STU_POSE)

#define	CMU_CSR_SYS_CMD_POSS	0U 
#define	CMU_CSR_SYS_CMD_POSE	2U 
#define	CMU_CSR_SYS_CMD_MSK	BITS(CMU_CSR_SYS_CMD_POSS,CMU_CSR_SYS_CMD_POSE)

/****************** Bit definition for CMU_CFGR register ************************/

#define	CMU_CFGR_QSPIRCS_POS	31U 
#define	CMU_CFGR_QSPIRCS_MSK	BIT(CMU_CFGR_QSPIRCS_POS)

#define	CMU_CFGR_QSPIRAEN_POS	30U 
#define	CMU_CFGR_QSPIRAEN_MSK	BIT(CMU_CFGR_QSPIRAEN_POS)

#define	CMU_CFGR_PCLK3DIV_POSS	26U 
#define	CMU_CFGR_PCLK3DIV_POSE	29U 
#define	CMU_CFGR_PCLK3DIV_MSK	BITS(CMU_CFGR_PCLK3DIV_POSS,CMU_CFGR_PCLK3DIV_POSE)

#define	CMU_CFGR_HRCFST_POS	25U 
#define	CMU_CFGR_HRCFST_MSK	BIT(CMU_CFGR_HRCFST_POS)

#define	CMU_CFGR_HRCFSW_POS	24U 
#define	CMU_CFGR_HRCFSW_MSK	BIT(CMU_CFGR_HRCFSW_POS)

#define	CMU_CFGR_PCLK2DIV_POSS	20U 
#define	CMU_CFGR_PCLK2DIV_POSE	23U 
#define	CMU_CFGR_PCLK2DIV_MSK	BITS(CMU_CFGR_PCLK2DIV_POSS,CMU_CFGR_PCLK2DIV_POSE)

#define	CMU_CFGR_PCLK1DIV_POSS	16U 
#define	CMU_CFGR_PCLK1DIV_POSE	19U 
#define	CMU_CFGR_PCLK1DIV_MSK	BITS(CMU_CFGR_PCLK1DIV_POSS,CMU_CFGR_PCLK1DIV_POSE)

#define	CMU_CFGR_HCLK4DIV_POSS	12U 
#define	CMU_CFGR_HCLK4DIV_POSE	15U 
#define	CMU_CFGR_HCLK4DIV_MSK	BITS(CMU_CFGR_HCLK4DIV_POSS,CMU_CFGR_HCLK4DIV_POSE)

#define	CMU_CFGR_HCLK3DIV_POSS	8U 
#define	CMU_CFGR_HCLK3DIV_POSE	11U 
#define	CMU_CFGR_HCLK3DIV_MSK	BITS(CMU_CFGR_HCLK3DIV_POSS,CMU_CFGR_HCLK3DIV_POSE)

#define	CMU_CFGR_HCLK2DIV_POSS	4U 
#define	CMU_CFGR_HCLK2DIV_POSE	7U 
#define	CMU_CFGR_HCLK2DIV_MSK	BITS(CMU_CFGR_HCLK2DIV_POSS,CMU_CFGR_HCLK2DIV_POSE)

#define	CMU_CFGR_HCLK1DIV_POSS	0U 
#define	CMU_CFGR_HCLK1DIV_POSE	3U 
#define	CMU_CFGR_HCLK1DIV_MSK	BITS(CMU_CFGR_HCLK1DIV_POSS,CMU_CFGR_HCLK1DIV_POSE)

/****************** Bit definition for CMU_CLKENR register ************************/

#define	CMU_CLKENR_HOSCETCEN_POS	13U 
#define	CMU_CLKENR_HOSCETCEN_MSK	BIT(CMU_CLKENR_HOSCETCEN_POS)

#define	CMU_CLKENR_HOSCHPS_POS	12U 
#define	CMU_CLKENR_HOSCHPS_MSK	BIT(CMU_CLKENR_HOSCHPS_POS)

#define	CMU_CLKENR_BIASEN_POS	11U 
#define	CMU_CLKENR_BIASEN_MSK	BIT(CMU_CLKENR_BIASEN_POS)

#define	CMU_CLKENR_LDOEN_POS	10U 
#define	CMU_CLKENR_LDOEN_MSK	BIT(CMU_CLKENR_LDOEN_POS)

#define	CMU_CLKENR_PLL1EN_96M_POS	9U 
#define	CMU_CLKENR_PLL1EN_96M_MSK	BIT(CMU_CLKENR_PLL1EN_96M_POS)

#define	CMU_CLKENR_PLL1EN_POS	8U 
#define	CMU_CLKENR_PLL1EN_MSK	BIT(CMU_CLKENR_PLL1EN_POS)

#define	CMU_CLKENR_HOSCBEN_POS	5U 
#define	CMU_CLKENR_HOSCBEN_MSK	BIT(CMU_CLKENR_HOSCBEN_POS)

#define	CMU_CLKENR_ULRCEN_POS	4U 
#define	CMU_CLKENR_ULRCEN_MSK	BIT(CMU_CLKENR_ULRCEN_POS)

#define	CMU_CLKENR_LRCEN_POS	3U 
#define	CMU_CLKENR_LRCEN_MSK	BIT(CMU_CLKENR_LRCEN_POS)

#define	CMU_CLKENR_HRCEN_POS	2U 
#define	CMU_CLKENR_HRCEN_MSK	BIT(CMU_CLKENR_HRCEN_POS)

#define	CMU_CLKENR_LOSCEN_POS	1U 
#define	CMU_CLKENR_LOSCEN_MSK	BIT(CMU_CLKENR_LOSCEN_POS)

#define	CMU_CLKENR_HOSCEN_POS	0U 
#define	CMU_CLKENR_HOSCEN_MSK	BIT(CMU_CLKENR_HOSCEN_POS)

/****************** Bit definition for CMU_CLKSR register ************************/

#define	CMU_CLKSR_PLL1RDY_POS	24U 
#define	CMU_CLKSR_PLL1RDY_MSK	BIT(CMU_CLKSR_PLL1RDY_POS)

#define	CMU_CLKSR_ULRCRDY_POS	20U 
#define	CMU_CLKSR_ULRCRDY_MSK	BIT(CMU_CLKSR_ULRCRDY_POS)

#define	CMU_CLKSR_LRCRDY_POS	19U 
#define	CMU_CLKSR_LRCRDY_MSK	BIT(CMU_CLKSR_LRCRDY_POS)

#define	CMU_CLKSR_HRCRDY_POS	18U 
#define	CMU_CLKSR_HRCRDY_MSK	BIT(CMU_CLKSR_HRCRDY_POS)

#define	CMU_CLKSR_LOSCRDY_POS	17U 
#define	CMU_CLKSR_LOSCRDY_MSK	BIT(CMU_CLKSR_LOSCRDY_POS)

#define	CMU_CLKSR_HOSCRDY_POS	16U 
#define	CMU_CLKSR_HOSCRDY_MSK	BIT(CMU_CLKSR_HOSCRDY_POS)

#define	CMU_CLKSR_PLL1ACT_POS	8U 
#define	CMU_CLKSR_PLL1ACT_MSK	BIT(CMU_CLKSR_PLL1ACT_POS)

#define	CMU_CLKSR_ULRCACT_POS	4U 
#define	CMU_CLKSR_ULRCACT_MSK	BIT(CMU_CLKSR_ULRCACT_POS)

#define	CMU_CLKSR_LRCACT_POS	3U 
#define	CMU_CLKSR_LRCACT_MSK	BIT(CMU_CLKSR_LRCACT_POS)

#define	CMU_CLKSR_HRCACT_POS	2U 
#define	CMU_CLKSR_HRCACT_MSK	BIT(CMU_CLKSR_HRCACT_POS)

#define	CMU_CLKSR_LOSCACT_POS	1U 
#define	CMU_CLKSR_LOSCACT_MSK	BIT(CMU_CLKSR_LOSCACT_POS)

#define	CMU_CLKSR_HOSCACT_POS	0U 
#define	CMU_CLKSR_HOSCACT_MSK	BIT(CMU_CLKSR_HOSCACT_POS)

/****************** Bit definition for CMU_PLLCFG register ************************/

#define	CMU_PLLCFG_PLL1LCKN_POS	31U 
#define	CMU_PLLCFG_PLL1LCKN_MSK	BIT(CMU_PLLCFG_PLL1LCKN_POS)

#define	CMU_PLLCFG_PLL1OS_POSS	24U 
#define	CMU_PLLCFG_PLL1OS_POSE	25U 
#define	CMU_PLLCFG_PLL1OS_MSK	BITS(CMU_PLLCFG_PLL1OS_POSS,CMU_PLLCFG_PLL1OS_POSE)

#define	CMU_PLLCFG_PLL1BYPS_POS	22U 
#define	CMU_PLLCFG_PLL1BYPS_MSK	BIT(CMU_PLLCFG_PLL1BYPS_POS)

#define	CMU_PLLCFG_PLL1RSV_POSS	20U 
#define	CMU_PLLCFG_PLL1RSV_POSE	21U 
#define	CMU_PLLCFG_PLL1RSV_MSK	BITS(CMU_PLLCFG_PLL1RSV_POSS,CMU_PLLCFG_PLL1RSV_POSE)

#define	CMU_PLLCFG_PLL1RDIV_POSS	12U 
#define	CMU_PLLCFG_PLL1RDIV_POSE	17U 
#define	CMU_PLLCFG_PLL1RDIV_MSK	BITS(CMU_PLLCFG_PLL1RDIV_POSS,CMU_PLLCFG_PLL1RDIV_POSE)

#define	CMU_PLLCFG_PLL1ICP_POSS	8U 
#define	CMU_PLLCFG_PLL1ICP_POSE	11U 
#define	CMU_PLLCFG_PLL1ICP_MSK	BITS(CMU_PLLCFG_PLL1ICP_POSS,CMU_PLLCFG_PLL1ICP_POSE)

#define	CMU_PLLCFG_PLL1SDIV_POSS	0U 
#define	CMU_PLLCFG_PLL1SDIV_POSE	6U 
#define	CMU_PLLCFG_PLL1SDIV_MSK	BITS(CMU_PLLCFG_PLL1SDIV_POSS,CMU_PLLCFG_PLL1SDIV_POSE)

/****************** Bit definition for CMU_HOSMCR register ************************/

#define	CMU_HOSMCR_STRPIE_POS	20U 
#define	CMU_HOSMCR_STRPIE_MSK	BIT(CMU_HOSMCR_STRPIE_POS)

#define	CMU_HOSMCR_STRIF_POS	19U 
#define	CMU_HOSMCR_STRIF_MSK	BIT(CMU_HOSMCR_STRIF_POS)

#define	CMU_HOSMCR_STPIF_POS	18U 
#define	CMU_HOSMCR_STPIF_MSK	BIT(CMU_HOSMCR_STPIF_POS)

#define	CMU_HOSMCR_STRIE_POS	17U 
#define	CMU_HOSMCR_STRIE_MSK	BIT(CMU_HOSMCR_STRIE_POS)

#define	CMU_HOSMCR_STPIE_POS	16U 
#define	CMU_HOSMCR_STPIE_MSK	BIT(CMU_HOSMCR_STPIE_POS)

#define	CMU_HOSMCR_FRQS_POSS	8U 
#define	CMU_HOSMCR_FRQS_POSE	10U 
#define	CMU_HOSMCR_FRQS_MSK	BITS(CMU_HOSMCR_FRQS_POSS,CMU_HOSMCR_FRQS_POSE)

#define	CMU_HOSMCR_CLKS_POS	1U 
#define	CMU_HOSMCR_CLKS_MSK	BIT(CMU_HOSMCR_CLKS_POS)

#define	CMU_HOSMCR_EN_POS	0U 
#define	CMU_HOSMCR_EN_MSK	BIT(CMU_HOSMCR_EN_POS)

/****************** Bit definition for CMU_LOSMCR register ************************/

#define	CMU_LOSMCR_STRIF_POS	19U 
#define	CMU_LOSMCR_STRIF_MSK	BIT(CMU_LOSMCR_STRIF_POS)

#define	CMU_LOSMCR_STPIF_POS	18U 
#define	CMU_LOSMCR_STPIF_MSK	BIT(CMU_LOSMCR_STPIF_POS)

#define	CMU_LOSMCR_STRIE_POS	17U 
#define	CMU_LOSMCR_STRIE_MSK	BIT(CMU_LOSMCR_STRIE_POS)

#define	CMU_LOSMCR_STPIE_POS	16U 
#define	CMU_LOSMCR_STPIE_MSK	BIT(CMU_LOSMCR_STPIE_POS)

#define	CMU_LOSMCR_CLKS_POS	1U 
#define	CMU_LOSMCR_CLKS_MSK	BIT(CMU_LOSMCR_CLKS_POS)

#define	CMU_LOSMCR_EN_POS	0U 
#define	CMU_LOSMCR_EN_MSK	BIT(CMU_LOSMCR_EN_POS)

/****************** Bit definition for CMU_PULMCR register ************************/

#define	CMU_PULMCR_LCULKIE_POS	20U 
#define	CMU_PULMCR_LCULKIE_MSK	BIT(CMU_PULMCR_LCULKIE_POS)

#define	CMU_PULMCR_LCKIF_POS	19U 
#define	CMU_PULMCR_LCKIF_MSK	BIT(CMU_PULMCR_LCKIF_POS)

#define	CMU_PULMCR_ULKIF_POS	18U 
#define	CMU_PULMCR_ULKIF_MSK	BIT(CMU_PULMCR_ULKIF_POS)

#define	CMU_PULMCR_LCKIE_POS	17U 
#define	CMU_PULMCR_LCKIE_MSK	BIT(CMU_PULMCR_LCKIE_POS)

#define	CMU_PULMCR_ULKIE_POS	16U 
#define	CMU_PULMCR_ULKIE_MSK	BIT(CMU_PULMCR_ULKIE_POS)

#define	CMU_PULMCR_MODE_POSS	8U 
#define	CMU_PULMCR_MODE_POSE	9U 
#define	CMU_PULMCR_MODE_MSK	BITS(CMU_PULMCR_MODE_POSS,CMU_PULMCR_MODE_POSE)

#define	CMU_PULMCR_CLKS_POS	1U 
#define	CMU_PULMCR_CLKS_MSK	BIT(CMU_PULMCR_CLKS_POS)

#define	CMU_PULMCR_EN_POS	0U 
#define	CMU_PULMCR_EN_MSK	BIT(CMU_PULMCR_EN_POS)

/****************** Bit definition for CMU_CLKOCR register ************************/

#define	CMU_CLKOCR_LSCOS_POSS	24U 
#define	CMU_CLKOCR_LSCOS_POSE	26U 
#define	CMU_CLKOCR_LSCOS_MSK	BITS(CMU_CLKOCR_LSCOS_POSS,CMU_CLKOCR_LSCOS_POSE)

#define	CMU_CLKOCR_LSCOEN_POS	16U 
#define	CMU_CLKOCR_LSCOEN_MSK	BIT(CMU_CLKOCR_LSCOEN_POS)

#define	CMU_CLKOCR_HSCODIV_POSS	12U 
#define	CMU_CLKOCR_HSCODIV_POSE	14U 
#define	CMU_CLKOCR_HSCODIV_MSK	BITS(CMU_CLKOCR_HSCODIV_POSS,CMU_CLKOCR_HSCODIV_POSE)

#define	CMU_CLKOCR_HSCOS_POSS	8U 
#define	CMU_CLKOCR_HSCOS_POSE	10U 
#define	CMU_CLKOCR_HSCOS_MSK	BITS(CMU_CLKOCR_HSCOS_POSS,CMU_CLKOCR_HSCOS_POSE)

#define	CMU_CLKOCR_HSCOEN_POS	0U 
#define	CMU_CLKOCR_HSCOEN_MSK	BIT(CMU_CLKOCR_HSCOEN_POS)

/****************** Bit definition for CMU_BUZZCR register ************************/

#define	CMU_BUZZCR_BUZZDAT_POSS	16U 
#define	CMU_BUZZCR_BUZZDAT_POSE	31U 
#define	CMU_BUZZCR_BUZZDAT_MSK	BITS(CMU_BUZZCR_BUZZDAT_POSS,CMU_BUZZCR_BUZZDAT_POSE)

#define	CMU_BUZZCR_BUZZDIV_POSS	8U 
#define	CMU_BUZZCR_BUZZDIV_POSE	10U 
#define	CMU_BUZZCR_BUZZDIV_MSK	BITS(CMU_BUZZCR_BUZZDIV_POSS,CMU_BUZZCR_BUZZDIV_POSE)

#define	CMU_BUZZCR_BUZZEN_POS	0U 
#define	CMU_BUZZCR_BUZZEN_MSK	BIT(CMU_BUZZCR_BUZZEN_POS)

/****************** Bit definition for CMU_AHB1ENR register ************************/

#define	CMU_AHB1ENR_SM3EN_POS	8U 
#define	CMU_AHB1ENR_SM3EN_MSK	BIT(CMU_AHB1ENR_SM3EN_POS)

#define	CMU_AHB1ENR_PISEN_POS	5U 
#define	CMU_AHB1ENR_PISEN_MSK	BIT(CMU_AHB1ENR_PISEN_POS)

#define	CMU_AHB1ENR_TRNGEN_POS	4U 
#define	CMU_AHB1ENR_TRNGEN_MSK	BIT(CMU_AHB1ENR_TRNGEN_POS)

#define	CMU_AHB1ENR_CRYPTEN_POS	3U 
#define	CMU_AHB1ENR_CRYPTEN_MSK	BIT(CMU_AHB1ENR_CRYPTEN_POS)

#define	CMU_AHB1ENR_CALCEN_POS	2U 
#define	CMU_AHB1ENR_CALCEN_MSK	BIT(CMU_AHB1ENR_CALCEN_POS)

#define	CMU_AHB1ENR_CRCEN_POS	1U 
#define	CMU_AHB1ENR_CRCEN_MSK	BIT(CMU_AHB1ENR_CRCEN_POS)

#define	CMU_AHB1ENR_GPIOEN_POS	0U 
#define	CMU_AHB1ENR_GPIOEN_MSK	BIT(CMU_AHB1ENR_GPIOEN_POS)

/****************** Bit definition for CMU_APB1ENR register ************************/

#define	CMU_APB1ENR_QUADEN_POS	30U 
#define	CMU_APB1ENR_QUADEN_MSK	BIT(CMU_APB1ENR_QUADEN_POS)

#define	CMU_APB1ENR_KSCANEN_POS	29U 
#define	CMU_APB1ENR_KSCANEN_MSK	BIT(CMU_APB1ENR_KSCANEN_POS)

#define	CMU_APB1ENR_QSPIEN_POS	28U 
#define	CMU_APB1ENR_QSPIEN_MSK	BIT(CMU_APB1ENR_QSPIEN_POS)

#define	CMU_APB1ENR_PDPCMEN_POS	27U 
#define	CMU_APB1ENR_PDPCMEN_MSK	BIT(CMU_APB1ENR_PDPCMEN_POS)

#define	CMU_APB1ENR_ECCEN_POS	26U 
#define	CMU_APB1ENR_ECCEN_MSK	BIT(CMU_APB1ENR_ECCEN_POS)

#define	CMU_APB1ENR_TKEN_POS	23U 
#define	CMU_APB1ENR_TKEN_MSK	BIT(CMU_APB1ENR_TKEN_POS)

#define	CMU_APB1ENR_ADPCMEN_POS	22U 
#define	CMU_APB1ENR_ADPCMEN_MSK	BIT(CMU_APB1ENR_ADPCMEN_POS)

#define	CMU_APB1ENR_I2C1EN_POS	21U 
#define	CMU_APB1ENR_I2C1EN_MSK	BIT(CMU_APB1ENR_I2C1EN_POS)

#define	CMU_APB1ENR_I2C0EN_POS	20U 
#define	CMU_APB1ENR_I2C0EN_MSK	BIT(CMU_APB1ENR_I2C0EN_POS)

#define	CMU_APB1ENR_SPI1EN_POS	17U 
#define	CMU_APB1ENR_SPI1EN_MSK	BIT(CMU_APB1ENR_SPI1EN_POS)

#define	CMU_APB1ENR_SPI0EN_POS	16U 
#define	CMU_APB1ENR_SPI0EN_MSK	BIT(CMU_APB1ENR_SPI0EN_POS)

#define	CMU_APB1ENR_UART2EN_POS	10U 
#define	CMU_APB1ENR_UART2EN_MSK	BIT(CMU_APB1ENR_UART2EN_POS)

#define	CMU_APB1ENR_UART1EN_POS	9U 
#define	CMU_APB1ENR_UART1EN_MSK	BIT(CMU_APB1ENR_UART1EN_POS)

#define	CMU_APB1ENR_UART0EN_POS	8U 
#define	CMU_APB1ENR_UART0EN_MSK	BIT(CMU_APB1ENR_UART0EN_POS)

#define	CMU_APB1ENR_TIM5EN_POS	5U 
#define	CMU_APB1ENR_TIM5EN_MSK	BIT(CMU_APB1ENR_TIM5EN_POS)

#define	CMU_APB1ENR_TIM4EN_POS	4U 
#define	CMU_APB1ENR_TIM4EN_MSK	BIT(CMU_APB1ENR_TIM4EN_POS)

#define	CMU_APB1ENR_TIM3EN_POS	3U 
#define	CMU_APB1ENR_TIM3EN_MSK	BIT(CMU_APB1ENR_TIM3EN_POS)

#define	CMU_APB1ENR_TIM2EN_POS	2U 
#define	CMU_APB1ENR_TIM2EN_MSK	BIT(CMU_APB1ENR_TIM2EN_POS)

#define	CMU_APB1ENR_TIM1EN_POS	1U 
#define	CMU_APB1ENR_TIM1EN_MSK	BIT(CMU_APB1ENR_TIM1EN_POS)

#define	CMU_APB1ENR_TIM0EN_POS	0U 
#define	CMU_APB1ENR_TIM0EN_MSK	BIT(CMU_APB1ENR_TIM0EN_POS)

/****************** Bit definition for CMU_APB2ENR register ************************/

#define	CMU_APB2ENR_DBGEN_POS	19U 
#define	CMU_APB2ENR_DBGEN_MSK	BIT(CMU_APB2ENR_DBGEN_POS)

#define	CMU_APB2ENR_BKPCEN_POS	16U 
#define	CMU_APB2ENR_BKPCEN_MSK	BIT(CMU_APB2ENR_BKPCEN_POS)

#define	CMU_APB2ENR_RTCEN_POS	15U 
#define	CMU_APB2ENR_RTCEN_MSK	BIT(CMU_APB2ENR_RTCEN_POS)

#define	CMU_APB2ENR_IWDTEN_POS	14U 
#define	CMU_APB2ENR_IWDTEN_MSK	BIT(CMU_APB2ENR_IWDTEN_POS)

#define	CMU_APB2ENR_WWDTEN_POS	12U 
#define	CMU_APB2ENR_WWDTEN_MSK	BIT(CMU_APB2ENR_WWDTEN_POS)

#define	CMU_APB2ENR_ADC0EN_POS	4U 
#define	CMU_APB2ENR_ADC0EN_MSK	BIT(CMU_APB2ENR_ADC0EN_POS)

#define	CMU_APB2ENR_LP16TEN_POS	0U 
#define	CMU_APB2ENR_LP16TEN_MSK	BIT(CMU_APB2ENR_LP16TEN_POS)

/****************** Bit definition for CMU_AHB1LPENR register ************************/

#define	CMU_AHB1LPENR_HRCEN_POS	2U 
#define	CMU_AHB1LPENR_HRCEN_MSK	BIT(CMU_AHB1LPENR_HRCEN_POS)

#define	CMU_AHB1LPENR_LOSCEN_POS	1U 
#define	CMU_AHB1LPENR_LOSCEN_MSK	BIT(CMU_AHB1LPENR_LOSCEN_POS)

#define	CMU_AHB1LPENR_LRCEN_POS	0U 
#define	CMU_AHB1LPENR_LRCEN_MSK	BIT(CMU_AHB1LPENR_LRCEN_POS)

/****************** Bit definition for CMU_PERICR register ************************/

#define	CMU_PERICR_LP16TCS_POSS	8U 
#define	CMU_PERICR_LP16TCS_POSE	10U 
#define	CMU_PERICR_LP16TCS_MSK	BITS(CMU_PERICR_LP16TCS_POSS,CMU_PERICR_LP16TCS_POSE)

/****************** Bit definition for CMU_CKLDOT register ************************/

#define	CMU_CKLDOT_LDOF_POS	31U 
#define	CMU_CKLDOT_LDOF_MSK	BIT(CMU_CKLDOT_LDOF_POS)

#define	CMU_CKLDOT_LDOT_POSS	0U 
#define	CMU_CKLDOT_LDOT_POSE	11U 
#define	CMU_CKLDOT_LDOT_MSK	BITS(CMU_CKLDOT_LDOT_POSS,CMU_CKLDOT_LDOT_POSE)

/****************** Bit definition for CMU_HOSCT register ************************/

#define	CMU_HOSCT_HOSCF_POS	31U 
#define	CMU_HOSCT_HOSCF_MSK	BIT(CMU_HOSCT_HOSCF_POS)

#define	CMU_HOSCT_HOSCT_POSS	0U 
#define	CMU_HOSCT_HOSCT_POSE	9U 
#define	CMU_HOSCT_HOSCT_MSK	BITS(CMU_HOSCT_HOSCT_POSS,CMU_HOSCT_HOSCT_POSE)

/****************** Bit definition for CMU_PLLT register ************************/

#define	CMU_PLLT_PLL1F_POS	31U 
#define	CMU_PLLT_PLL1F_MSK	BIT(CMU_PLLT_PLL1F_POS)

#define	CMU_PLLT_PLL1T_POSS	0U 
#define	CMU_PLLT_PLL1T_POSE	4U 
#define	CMU_PLLT_PLL1T_MSK	BITS(CMU_PLLT_PLL1T_POSS,CMU_PLLT_PLL1T_POSE)

/****************** Bit definition for CMU_CKSEQR register ************************/

#define	CMU_CKSEQR_LOCK_BYP_POS	1U 
#define	CMU_CKSEQR_LOCK_BYP_MSK	BIT(CMU_CKSEQR_LOCK_BYP_POS)

#define	CMU_CKSEQR_CKSTM_POS	0U 
#define	CMU_CKSEQR_CKSTM_MSK	BIT(CMU_CKSEQR_CKSTM_POS)

/****************** Bit definition for CMU_PDPCMCFG register ************************/

#define	CMU_PDPCMCFG_FDIV_POSS	16U 
#define	CMU_PDPCMCFG_FDIV_POSE	19U 
#define	CMU_PDPCMCFG_FDIV_MSK	BITS(CMU_PDPCMCFG_FDIV_POSS,CMU_PDPCMCFG_FDIV_POSE)

#define	CMU_PDPCMCFG_FW_POSS	0U 
#define	CMU_PDPCMCFG_FW_POSE	15U 
#define	CMU_PDPCMCFG_FW_MSK	BITS(CMU_PDPCMCFG_FW_POSS,CMU_PDPCMCFG_FW_POSE)

/****************** Bit definition for CMU_BLEENR register ************************/

#define	CMU_BLEENR_MDMEN1_POS	3U 
#define	CMU_BLEENR_MDMEN1_MSK	BIT(CMU_BLEENR_MDMEN1_POS)

#define	CMU_BLEENR_MDMEN0_POS	2U 
#define	CMU_BLEENR_MDMEN0_MSK	BIT(CMU_BLEENR_MDMEN0_POS)

#define	CMU_BLEENR_BBEN1_POS	1U 
#define	CMU_BLEENR_BBEN1_MSK	BIT(CMU_BLEENR_BBEN1_POS)

#define	CMU_BLEENR_BBEN0_POS	0U 
#define	CMU_BLEENR_BBEN0_MSK	BIT(CMU_BLEENR_BBEN0_POS)

/****************** Bit definition for CMU_BLECFG register ************************/

#define	CMU_BLECFG_BBMCKS_POSS	0U 
#define	CMU_BLECFG_BBMCKS_POSE	1U 
#define	CMU_BLECFG_BBMCKS_MSK	BITS(CMU_BLECFG_BBMCKS_POSS,CMU_BLECFG_BBMCKS_POSE)

/****************** Bit definition for CMU_BLECKS register ************************/

#define	CMU_BLECKS_BBSCKS_POSS	0U 
#define	CMU_BLECKS_BBSCKS_POSE	5U 
#define	CMU_BLECKS_BBSCKS_MSK	BITS(CMU_BLECKS_BBSCKS_POSS,CMU_BLECKS_BBSCKS_POSE)

/****************** Bit definition for CMU_ULRCUMC register ************************/

#define	CMU_ULRCUMC_UMCST_POSS	16U 
#define	CMU_ULRCUMC_UMCST_POSE	31U 
#define	CMU_ULRCUMC_UMCST_MSK	BITS(CMU_ULRCUMC_UMCST_POSS,CMU_ULRCUMC_UMCST_POSE)

#define	CMU_ULRCUMC_IBISEL_POSS	12U 
#define	CMU_ULRCUMC_IBISEL_POSE	13U 
#define	CMU_ULRCUMC_IBISEL_MSK	BITS(CMU_ULRCUMC_IBISEL_POSS,CMU_ULRCUMC_IBISEL_POSE)

#define	CMU_ULRCUMC_ISEL_POSS	8U 
#define	CMU_ULRCUMC_ISEL_POSE	11U 
#define	CMU_ULRCUMC_ISEL_MSK	BITS(CMU_ULRCUMC_ISEL_POSS,CMU_ULRCUMC_ISEL_POSE)

#define	CMU_ULRCUMC_CAPSEL_POSS	0U 
#define	CMU_ULRCUMC_CAPSEL_POSE	7U 
#define	CMU_ULRCUMC_CAPSEL_MSK	BITS(CMU_ULRCUMC_CAPSEL_POSS,CMU_ULRCUMC_CAPSEL_POSE)

/****************** Bit definition for CMU_LRCUMC0 register ************************/

#define	CMU_LRCUMC0_UMCST0_POSS	16U 
#define	CMU_LRCUMC0_UMCST0_POSE	31U 
#define	CMU_LRCUMC0_UMCST0_MSK	BITS(CMU_LRCUMC0_UMCST0_POSS,CMU_LRCUMC0_UMCST0_POSE)

#define	CMU_LRCUMC0_VDDSEL_POS	14U 
#define	CMU_LRCUMC0_VDDSEL_MSK	BIT(CMU_LRCUMC0_VDDSEL_POS)

#define	CMU_LRCUMC0_BUF_ISEL_POSS	12U 
#define	CMU_LRCUMC0_BUF_ISEL_POSE	13U 
#define	CMU_LRCUMC0_BUF_ISEL_MSK	BITS(CMU_LRCUMC0_BUF_ISEL_POSS,CMU_LRCUMC0_BUF_ISEL_POSE)

#define	CMU_LRCUMC0_ISEL_POSS	8U 
#define	CMU_LRCUMC0_ISEL_POSE	11U 
#define	CMU_LRCUMC0_ISEL_MSK	BITS(CMU_LRCUMC0_ISEL_POSS,CMU_LRCUMC0_ISEL_POSE)

#define	CMU_LRCUMC0_CAPSEL_POSS	0U 
#define	CMU_LRCUMC0_CAPSEL_POSE	7U 
#define	CMU_LRCUMC0_CAPSEL_MSK	BITS(CMU_LRCUMC0_CAPSEL_POSS,CMU_LRCUMC0_CAPSEL_POSE)

/****************** Bit definition for CMU_LRCUMC1 register ************************/

#define	CMU_LRCUMC1_UMCST1_POSS	16U 
#define	CMU_LRCUMC1_UMCST1_POSE	31U 
#define	CMU_LRCUMC1_UMCST1_MSK	BITS(CMU_LRCUMC1_UMCST1_POSS,CMU_LRCUMC1_UMCST1_POSE)

#define	CMU_LRCUMC1_LDO_CAL_POSS	0U 
#define	CMU_LRCUMC1_LDO_CAL_POSE	13U 
#define	CMU_LRCUMC1_LDO_CAL_MSK	BITS(CMU_LRCUMC1_LDO_CAL_POSS,CMU_LRCUMC1_LDO_CAL_POSE)

/****************** Bit definition for CMU_LOSCUMC0 register ************************/

#define	CMU_LOSCUMC0_UMCST0_POSS	16U 
#define	CMU_LOSCUMC0_UMCST0_POSE	31U 
#define	CMU_LOSCUMC0_UMCST0_MSK	BITS(CMU_LOSCUMC0_UMCST0_POSS,CMU_LOSCUMC0_UMCST0_POSE)

#define	CMU_LOSCUMC0_IBSEL_POSS	14U 
#define	CMU_LOSCUMC0_IBSEL_POSE	15U 
#define	CMU_LOSCUMC0_IBSEL_MSK	BITS(CMU_LOSCUMC0_IBSEL_POSS,CMU_LOSCUMC0_IBSEL_POSE)

#define	CMU_LOSCUMC0_AMP_POSS	12U 
#define	CMU_LOSCUMC0_AMP_POSE	13U 
#define	CMU_LOSCUMC0_AMP_MSK	BITS(CMU_LOSCUMC0_AMP_POSS,CMU_LOSCUMC0_AMP_POSE)

#define	CMU_LOSCUMC0_HS_LDO_POSS	8U 
#define	CMU_LOSCUMC0_HS_LDO_POSE	10U 
#define	CMU_LOSCUMC0_HS_LDO_MSK	BITS(CMU_LOSCUMC0_HS_LDO_POSS,CMU_LOSCUMC0_HS_LDO_POSE)

#define	CMU_LOSCUMC0_FBRESSEL_POSS	4U 
#define	CMU_LOSCUMC0_FBRESSEL_POSE	7U 
#define	CMU_LOSCUMC0_FBRESSEL_MSK	BITS(CMU_LOSCUMC0_FBRESSEL_POSS,CMU_LOSCUMC0_FBRESSEL_POSE)

#define	CMU_LOSCUMC0_CAPSEL_POSS	2U 
#define	CMU_LOSCUMC0_CAPSEL_POSE	3U 
#define	CMU_LOSCUMC0_CAPSEL_MSK	BITS(CMU_LOSCUMC0_CAPSEL_POSS,CMU_LOSCUMC0_CAPSEL_POSE)

#define	CMU_LOSCUMC0_IRESSEL_POSS	0U 
#define	CMU_LOSCUMC0_IRESSEL_POSE	1U 
#define	CMU_LOSCUMC0_IRESSEL_MSK	BITS(CMU_LOSCUMC0_IRESSEL_POSS,CMU_LOSCUMC0_IRESSEL_POSE)

/****************** Bit definition for CMU_LOSCUMC1 register ************************/

#define	CMU_LOSCUMC1_UMCST1_POSS	16U 
#define	CMU_LOSCUMC1_UMCST1_POSE	31U 
#define	CMU_LOSCUMC1_UMCST1_MSK	BITS(CMU_LOSCUMC1_UMCST1_POSS,CMU_LOSCUMC1_UMCST1_POSE)

#define	CMU_LOSCUMC1_VSEL_POSS	0U 
#define	CMU_LOSCUMC1_VSEL_POSE	4U 
#define	CMU_LOSCUMC1_VSEL_MSK	BITS(CMU_LOSCUMC1_VSEL_POSS,CMU_LOSCUMC1_VSEL_POSE)

/****************** Bit definition for CMU_HOSCUMC register ************************/

#define	CMU_HOSCUMC_UMCST_POSS	16U 
#define	CMU_HOSCUMC_UMCST_POSE	31U 
#define	CMU_HOSCUMC_UMCST_MSK	BITS(CMU_HOSCUMC_UMCST_POSS,CMU_HOSCUMC_UMCST_POSE)

#define	CMU_HOSCUMC_CAPCAL_POSS	4U 
#define	CMU_HOSCUMC_CAPCAL_POSE	11U 
#define	CMU_HOSCUMC_CAPCAL_MSK	BITS(CMU_HOSCUMC_CAPCAL_POSS,CMU_HOSCUMC_CAPCAL_POSE)

#define	CMU_HOSCUMC_BIAS_POSS	0U 
#define	CMU_HOSCUMC_BIAS_POSE	3U 
#define	CMU_HOSCUMC_BIAS_MSK	BITS(CMU_HOSCUMC_BIAS_POSS,CMU_HOSCUMC_BIAS_POSE)

typedef struct
{
	__O uint32_t CSR;
	__IO uint32_t CFGR;
	uint32_t RESERVED0[2] ;
	__IO uint32_t CLKENR;
	__I uint32_t CLKSR;
	__IO uint32_t PLLCFG;
	uint32_t RESERVED1 ;
	__IO uint32_t HOSMCR;
	__IO uint32_t LOSMCR;
	__IO uint32_t PULMCR;
	uint32_t RESERVED2 ;
	__IO uint32_t CLKOCR;
	__IO uint32_t BUZZCR;
	uint32_t RESERVED3[2] ;
	__IO uint32_t AHB1ENR;
	uint32_t RESERVED4[3] ;
	__IO uint32_t APB1ENR;
	__IO uint32_t APB2ENR;
	uint32_t RESERVED5[2] ;
	__IO uint32_t AHB1LPENR;
	uint32_t RESERVED6[7] ;
	__IO uint32_t PERICR;
	__IO uint32_t CKLDOT;
	__IO uint32_t HOSCT;
	__IO uint32_t PLLT;
	__IO uint32_t CKSEQR;
	uint32_t RESERVED7[7] ;
	__IO uint32_t PDPCMCFG;
	uint32_t RESERVED8[3] ;
	__IO uint32_t BLEENR;
	__IO uint32_t BLECFG;
	__IO uint32_t BLECKS;
	uint32_t RESERVED9[5] ;
	__IO uint32_t ULRCUMC;
	__IO uint32_t LRCUMC0;
	__IO uint32_t LRCUMC1;
	__IO uint32_t LOSCUMC0;
	__IO uint32_t LOSCUMC1;
	__IO uint32_t HOSCUMC;
} CMU_TypeDef;





#endif
