/**
  **************************************************************************************
  * @file    REG_PIS.h
  * @brief   PIS Head File
  *
  * @version V0.01
  * @data    8/17/2020
  * @author  Eastsoft MCU Software Team
  * @note
  *
  * Copyright (C) 2018 Shanghai Eastsoft Microelectronics Co., Ltd. ALL rights reserved.
  *
  **************************************************************************************
  */

#ifndef __PIS_H__
#define __PIS_H__


/******************************************************************************/
/*                              设备特殊寄存器结构定义                        */
/******************************************************************************/

/*   允许匿名结构和匿名联合    */
 

/****************** Bit definition for PIS_CH0_CON register ************************/

#define	PIS_CH0_CON_SYNCSEL_POSS	24U 
#define	PIS_CH0_CON_SYNCSEL_POSE	26U 
#define	PIS_CH0_CON_SYNCSEL_MSK	BITS(PIS_CH0_CON_SYNCSEL_POSS,PIS_CH0_CON_SYNCSEL_POSE)

#define	PIS_CH0_CON_PULCK_POSS	18U 
#define	PIS_CH0_CON_PULCK_POSE	19U 
#define	PIS_CH0_CON_PULCK_MSK	BITS(PIS_CH0_CON_PULCK_POSS,PIS_CH0_CON_PULCK_POSE)

#define	PIS_CH0_CON_EDGS_POSS	16U 
#define	PIS_CH0_CON_EDGS_POSE	17U 
#define	PIS_CH0_CON_EDGS_MSK	BITS(PIS_CH0_CON_EDGS_POSS,PIS_CH0_CON_EDGS_POSE)

#define	PIS_CH0_CON_SRCS_POSS	8U 
#define	PIS_CH0_CON_SRCS_POSE	13U 
#define	PIS_CH0_CON_SRCS_MSK	BITS(PIS_CH0_CON_SRCS_POSS,PIS_CH0_CON_SRCS_POSE)

#define	PIS_CH0_CON_MSIGS_POSS	0U 
#define	PIS_CH0_CON_MSIGS_POSE	3U 
#define	PIS_CH0_CON_MSIGS_MSK	BITS(PIS_CH0_CON_MSIGS_POSS,PIS_CH0_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH1_CON register ************************/

#define	PIS_CH1_CON_SYNCSEL_POSS	24U 
#define	PIS_CH1_CON_SYNCSEL_POSE	26U 
#define	PIS_CH1_CON_SYNCSEL_MSK	BITS(PIS_CH1_CON_SYNCSEL_POSS,PIS_CH1_CON_SYNCSEL_POSE)

#define	PIS_CH1_CON_PULCK_POSS	18U 
#define	PIS_CH1_CON_PULCK_POSE	19U 
#define	PIS_CH1_CON_PULCK_MSK	BITS(PIS_CH1_CON_PULCK_POSS,PIS_CH1_CON_PULCK_POSE)

#define	PIS_CH1_CON_EDGS_POSS	16U 
#define	PIS_CH1_CON_EDGS_POSE	17U 
#define	PIS_CH1_CON_EDGS_MSK	BITS(PIS_CH1_CON_EDGS_POSS,PIS_CH1_CON_EDGS_POSE)

#define	PIS_CH1_CON_SRCS_POSS	8U 
#define	PIS_CH1_CON_SRCS_POSE	13U 
#define	PIS_CH1_CON_SRCS_MSK	BITS(PIS_CH1_CON_SRCS_POSS,PIS_CH1_CON_SRCS_POSE)

#define	PIS_CH1_CON_MSIGS_POSS	0U 
#define	PIS_CH1_CON_MSIGS_POSE	3U 
#define	PIS_CH1_CON_MSIGS_MSK	BITS(PIS_CH1_CON_MSIGS_POSS,PIS_CH1_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH2_CON register ************************/

#define	PIS_CH2_CON_SYNCSEL_POSS	24U 
#define	PIS_CH2_CON_SYNCSEL_POSE	26U 
#define	PIS_CH2_CON_SYNCSEL_MSK	BITS(PIS_CH2_CON_SYNCSEL_POSS,PIS_CH2_CON_SYNCSEL_POSE)

#define	PIS_CH2_CON_PULCK_POSS	18U 
#define	PIS_CH2_CON_PULCK_POSE	19U 
#define	PIS_CH2_CON_PULCK_MSK	BITS(PIS_CH2_CON_PULCK_POSS,PIS_CH2_CON_PULCK_POSE)

#define	PIS_CH2_CON_EDGS_POSS	16U 
#define	PIS_CH2_CON_EDGS_POSE	17U 
#define	PIS_CH2_CON_EDGS_MSK	BITS(PIS_CH2_CON_EDGS_POSS,PIS_CH2_CON_EDGS_POSE)

#define	PIS_CH2_CON_SRCS_POSS	8U 
#define	PIS_CH2_CON_SRCS_POSE	13U 
#define	PIS_CH2_CON_SRCS_MSK	BITS(PIS_CH2_CON_SRCS_POSS,PIS_CH2_CON_SRCS_POSE)

#define	PIS_CH2_CON_MSIGS_POSS	0U 
#define	PIS_CH2_CON_MSIGS_POSE	3U 
#define	PIS_CH2_CON_MSIGS_MSK	BITS(PIS_CH2_CON_MSIGS_POSS,PIS_CH2_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH3_CON register ************************/

#define	PIS_CH3_CON_SYNCSEL_POSS	24U 
#define	PIS_CH3_CON_SYNCSEL_POSE	26U 
#define	PIS_CH3_CON_SYNCSEL_MSK	BITS(PIS_CH3_CON_SYNCSEL_POSS,PIS_CH3_CON_SYNCSEL_POSE)

#define	PIS_CH3_CON_PULCK_POSS	18U 
#define	PIS_CH3_CON_PULCK_POSE	19U 
#define	PIS_CH3_CON_PULCK_MSK	BITS(PIS_CH3_CON_PULCK_POSS,PIS_CH3_CON_PULCK_POSE)

#define	PIS_CH3_CON_EDGS_POSS	16U 
#define	PIS_CH3_CON_EDGS_POSE	17U 
#define	PIS_CH3_CON_EDGS_MSK	BITS(PIS_CH3_CON_EDGS_POSS,PIS_CH3_CON_EDGS_POSE)

#define	PIS_CH3_CON_SRCS_POSS	8U 
#define	PIS_CH3_CON_SRCS_POSE	13U 
#define	PIS_CH3_CON_SRCS_MSK	BITS(PIS_CH3_CON_SRCS_POSS,PIS_CH3_CON_SRCS_POSE)

#define	PIS_CH3_CON_MSIGS_POSS	0U 
#define	PIS_CH3_CON_MSIGS_POSE	3U 
#define	PIS_CH3_CON_MSIGS_MSK	BITS(PIS_CH3_CON_MSIGS_POSS,PIS_CH3_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH4_CON register ************************/

#define	PIS_CH4_CON_SYNCSEL_POSS	24U 
#define	PIS_CH4_CON_SYNCSEL_POSE	26U 
#define	PIS_CH4_CON_SYNCSEL_MSK	BITS(PIS_CH4_CON_SYNCSEL_POSS,PIS_CH4_CON_SYNCSEL_POSE)

#define	PIS_CH4_CON_PULCK_POSS	18U 
#define	PIS_CH4_CON_PULCK_POSE	19U 
#define	PIS_CH4_CON_PULCK_MSK	BITS(PIS_CH4_CON_PULCK_POSS,PIS_CH4_CON_PULCK_POSE)

#define	PIS_CH4_CON_EDGS_POSS	16U 
#define	PIS_CH4_CON_EDGS_POSE	17U 
#define	PIS_CH4_CON_EDGS_MSK	BITS(PIS_CH4_CON_EDGS_POSS,PIS_CH4_CON_EDGS_POSE)

#define	PIS_CH4_CON_SRCS_POSS	8U 
#define	PIS_CH4_CON_SRCS_POSE	13U 
#define	PIS_CH4_CON_SRCS_MSK	BITS(PIS_CH4_CON_SRCS_POSS,PIS_CH4_CON_SRCS_POSE)

#define	PIS_CH4_CON_MSIGS_POSS	0U 
#define	PIS_CH4_CON_MSIGS_POSE	3U 
#define	PIS_CH4_CON_MSIGS_MSK	BITS(PIS_CH4_CON_MSIGS_POSS,PIS_CH4_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH5_CON register ************************/

#define	PIS_CH5_CON_SYNCSEL_POSS	24U 
#define	PIS_CH5_CON_SYNCSEL_POSE	26U 
#define	PIS_CH5_CON_SYNCSEL_MSK	BITS(PIS_CH5_CON_SYNCSEL_POSS,PIS_CH5_CON_SYNCSEL_POSE)

#define	PIS_CH5_CON_PULCK_POSS	18U 
#define	PIS_CH5_CON_PULCK_POSE	19U 
#define	PIS_CH5_CON_PULCK_MSK	BITS(PIS_CH5_CON_PULCK_POSS,PIS_CH5_CON_PULCK_POSE)

#define	PIS_CH5_CON_EDGS_POSS	16U 
#define	PIS_CH5_CON_EDGS_POSE	17U 
#define	PIS_CH5_CON_EDGS_MSK	BITS(PIS_CH5_CON_EDGS_POSS,PIS_CH5_CON_EDGS_POSE)

#define	PIS_CH5_CON_SRCS_POSS	8U 
#define	PIS_CH5_CON_SRCS_POSE	13U 
#define	PIS_CH5_CON_SRCS_MSK	BITS(PIS_CH5_CON_SRCS_POSS,PIS_CH5_CON_SRCS_POSE)

#define	PIS_CH5_CON_MSIGS_POSS	0U 
#define	PIS_CH5_CON_MSIGS_POSE	3U 
#define	PIS_CH5_CON_MSIGS_MSK	BITS(PIS_CH5_CON_MSIGS_POSS,PIS_CH5_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH6_CON register ************************/

#define	PIS_CH6_CON_SYNCSEL_POSS	24U 
#define	PIS_CH6_CON_SYNCSEL_POSE	26U 
#define	PIS_CH6_CON_SYNCSEL_MSK	BITS(PIS_CH6_CON_SYNCSEL_POSS,PIS_CH6_CON_SYNCSEL_POSE)

#define	PIS_CH6_CON_PULCK_POSS	18U 
#define	PIS_CH6_CON_PULCK_POSE	19U 
#define	PIS_CH6_CON_PULCK_MSK	BITS(PIS_CH6_CON_PULCK_POSS,PIS_CH6_CON_PULCK_POSE)

#define	PIS_CH6_CON_EDGS_POSS	16U 
#define	PIS_CH6_CON_EDGS_POSE	17U 
#define	PIS_CH6_CON_EDGS_MSK	BITS(PIS_CH6_CON_EDGS_POSS,PIS_CH6_CON_EDGS_POSE)

#define	PIS_CH6_CON_SRCS_POSS	8U 
#define	PIS_CH6_CON_SRCS_POSE	13U 
#define	PIS_CH6_CON_SRCS_MSK	BITS(PIS_CH6_CON_SRCS_POSS,PIS_CH6_CON_SRCS_POSE)

#define	PIS_CH6_CON_MSIGS_POSS	0U 
#define	PIS_CH6_CON_MSIGS_POSE	3U 
#define	PIS_CH6_CON_MSIGS_MSK	BITS(PIS_CH6_CON_MSIGS_POSS,PIS_CH6_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH7_CON register ************************/

#define	PIS_CH7_CON_SYNCSEL_POSS	24U 
#define	PIS_CH7_CON_SYNCSEL_POSE	26U 
#define	PIS_CH7_CON_SYNCSEL_MSK	BITS(PIS_CH7_CON_SYNCSEL_POSS,PIS_CH7_CON_SYNCSEL_POSE)

#define	PIS_CH7_CON_PULCK_POSS	18U 
#define	PIS_CH7_CON_PULCK_POSE	19U 
#define	PIS_CH7_CON_PULCK_MSK	BITS(PIS_CH7_CON_PULCK_POSS,PIS_CH7_CON_PULCK_POSE)

#define	PIS_CH7_CON_EDGS_POSS	16U 
#define	PIS_CH7_CON_EDGS_POSE	17U 
#define	PIS_CH7_CON_EDGS_MSK	BITS(PIS_CH7_CON_EDGS_POSS,PIS_CH7_CON_EDGS_POSE)

#define	PIS_CH7_CON_SRCS_POSS	8U 
#define	PIS_CH7_CON_SRCS_POSE	13U 
#define	PIS_CH7_CON_SRCS_MSK	BITS(PIS_CH7_CON_SRCS_POSS,PIS_CH7_CON_SRCS_POSE)

#define	PIS_CH7_CON_MSIGS_POSS	0U 
#define	PIS_CH7_CON_MSIGS_POSE	3U 
#define	PIS_CH7_CON_MSIGS_MSK	BITS(PIS_CH7_CON_MSIGS_POSS,PIS_CH7_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH8_CON register ************************/

#define	PIS_CH8_CON_SYNCSEL_POSS	24U 
#define	PIS_CH8_CON_SYNCSEL_POSE	26U 
#define	PIS_CH8_CON_SYNCSEL_MSK	BITS(PIS_CH8_CON_SYNCSEL_POSS,PIS_CH8_CON_SYNCSEL_POSE)

#define	PIS_CH8_CON_PULCK_POSS	18U 
#define	PIS_CH8_CON_PULCK_POSE	19U 
#define	PIS_CH8_CON_PULCK_MSK	BITS(PIS_CH8_CON_PULCK_POSS,PIS_CH8_CON_PULCK_POSE)

#define	PIS_CH8_CON_EDGS_POSS	16U 
#define	PIS_CH8_CON_EDGS_POSE	17U 
#define	PIS_CH8_CON_EDGS_MSK	BITS(PIS_CH8_CON_EDGS_POSS,PIS_CH8_CON_EDGS_POSE)

#define	PIS_CH8_CON_SRCS_POSS	8U 
#define	PIS_CH8_CON_SRCS_POSE	13U 
#define	PIS_CH8_CON_SRCS_MSK	BITS(PIS_CH8_CON_SRCS_POSS,PIS_CH8_CON_SRCS_POSE)

#define	PIS_CH8_CON_MSIGS_POSS	0U 
#define	PIS_CH8_CON_MSIGS_POSE	3U 
#define	PIS_CH8_CON_MSIGS_MSK	BITS(PIS_CH8_CON_MSIGS_POSS,PIS_CH8_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH9_CON register ************************/

#define	PIS_CH9_CON_SYNCSEL_POSS	24U 
#define	PIS_CH9_CON_SYNCSEL_POSE	26U 
#define	PIS_CH9_CON_SYNCSEL_MSK	BITS(PIS_CH9_CON_SYNCSEL_POSS,PIS_CH9_CON_SYNCSEL_POSE)

#define	PIS_CH9_CON_PULCK_POSS	18U 
#define	PIS_CH9_CON_PULCK_POSE	19U 
#define	PIS_CH9_CON_PULCK_MSK	BITS(PIS_CH9_CON_PULCK_POSS,PIS_CH9_CON_PULCK_POSE)

#define	PIS_CH9_CON_EDGS_POSS	16U 
#define	PIS_CH9_CON_EDGS_POSE	17U 
#define	PIS_CH9_CON_EDGS_MSK	BITS(PIS_CH9_CON_EDGS_POSS,PIS_CH9_CON_EDGS_POSE)

#define	PIS_CH9_CON_SRCS_POSS	8U 
#define	PIS_CH9_CON_SRCS_POSE	13U 
#define	PIS_CH9_CON_SRCS_MSK	BITS(PIS_CH9_CON_SRCS_POSS,PIS_CH9_CON_SRCS_POSE)

#define	PIS_CH9_CON_MSIGS_POSS	0U 
#define	PIS_CH9_CON_MSIGS_POSE	3U 
#define	PIS_CH9_CON_MSIGS_MSK	BITS(PIS_CH9_CON_MSIGS_POSS,PIS_CH9_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH10_CON register ************************/

#define	PIS_CH10_CON_SYNCSEL_POSS	24U 
#define	PIS_CH10_CON_SYNCSEL_POSE	26U 
#define	PIS_CH10_CON_SYNCSEL_MSK	BITS(PIS_CH10_CON_SYNCSEL_POSS,PIS_CH10_CON_SYNCSEL_POSE)

#define	PIS_CH10_CON_PULCK_POSS	18U 
#define	PIS_CH10_CON_PULCK_POSE	19U 
#define	PIS_CH10_CON_PULCK_MSK	BITS(PIS_CH10_CON_PULCK_POSS,PIS_CH10_CON_PULCK_POSE)

#define	PIS_CH10_CON_EDGS_POSS	16U 
#define	PIS_CH10_CON_EDGS_POSE	17U 
#define	PIS_CH10_CON_EDGS_MSK	BITS(PIS_CH10_CON_EDGS_POSS,PIS_CH10_CON_EDGS_POSE)

#define	PIS_CH10_CON_SRCS_POSS	8U 
#define	PIS_CH10_CON_SRCS_POSE	13U 
#define	PIS_CH10_CON_SRCS_MSK	BITS(PIS_CH10_CON_SRCS_POSS,PIS_CH10_CON_SRCS_POSE)

#define	PIS_CH10_CON_MSIGS_POSS	0U 
#define	PIS_CH10_CON_MSIGS_POSE	3U 
#define	PIS_CH10_CON_MSIGS_MSK	BITS(PIS_CH10_CON_MSIGS_POSS,PIS_CH10_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH11_CON register ************************/

#define	PIS_CH11_CON_SYNCSEL_POSS	24U 
#define	PIS_CH11_CON_SYNCSEL_POSE	26U 
#define	PIS_CH11_CON_SYNCSEL_MSK	BITS(PIS_CH11_CON_SYNCSEL_POSS,PIS_CH11_CON_SYNCSEL_POSE)

#define	PIS_CH11_CON_PULCK_POSS	18U 
#define	PIS_CH11_CON_PULCK_POSE	19U 
#define	PIS_CH11_CON_PULCK_MSK	BITS(PIS_CH11_CON_PULCK_POSS,PIS_CH11_CON_PULCK_POSE)

#define	PIS_CH11_CON_EDGS_POSS	16U 
#define	PIS_CH11_CON_EDGS_POSE	17U 
#define	PIS_CH11_CON_EDGS_MSK	BITS(PIS_CH11_CON_EDGS_POSS,PIS_CH11_CON_EDGS_POSE)

#define	PIS_CH11_CON_SRCS_POSS	8U 
#define	PIS_CH11_CON_SRCS_POSE	13U 
#define	PIS_CH11_CON_SRCS_MSK	BITS(PIS_CH11_CON_SRCS_POSS,PIS_CH11_CON_SRCS_POSE)

#define	PIS_CH11_CON_MSIGS_POSS	0U 
#define	PIS_CH11_CON_MSIGS_POSE	3U 
#define	PIS_CH11_CON_MSIGS_MSK	BITS(PIS_CH11_CON_MSIGS_POSS,PIS_CH11_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH12_CON register ************************/

#define	PIS_CH12_CON_SYNCSEL_POSS	24U 
#define	PIS_CH12_CON_SYNCSEL_POSE	26U 
#define	PIS_CH12_CON_SYNCSEL_MSK	BITS(PIS_CH12_CON_SYNCSEL_POSS,PIS_CH12_CON_SYNCSEL_POSE)

#define	PIS_CH12_CON_PULCK_POSS	18U 
#define	PIS_CH12_CON_PULCK_POSE	19U 
#define	PIS_CH12_CON_PULCK_MSK	BITS(PIS_CH12_CON_PULCK_POSS,PIS_CH12_CON_PULCK_POSE)

#define	PIS_CH12_CON_EDGS_POSS	16U 
#define	PIS_CH12_CON_EDGS_POSE	17U 
#define	PIS_CH12_CON_EDGS_MSK	BITS(PIS_CH12_CON_EDGS_POSS,PIS_CH12_CON_EDGS_POSE)

#define	PIS_CH12_CON_SRCS_POSS	8U 
#define	PIS_CH12_CON_SRCS_POSE	13U 
#define	PIS_CH12_CON_SRCS_MSK	BITS(PIS_CH12_CON_SRCS_POSS,PIS_CH12_CON_SRCS_POSE)

#define	PIS_CH12_CON_MSIGS_POSS	0U 
#define	PIS_CH12_CON_MSIGS_POSE	3U 
#define	PIS_CH12_CON_MSIGS_MSK	BITS(PIS_CH12_CON_MSIGS_POSS,PIS_CH12_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH13_CON register ************************/

#define	PIS_CH13_CON_SYNCSEL_POSS	24U 
#define	PIS_CH13_CON_SYNCSEL_POSE	26U 
#define	PIS_CH13_CON_SYNCSEL_MSK	BITS(PIS_CH13_CON_SYNCSEL_POSS,PIS_CH13_CON_SYNCSEL_POSE)

#define	PIS_CH13_CON_PULCK_POSS	18U 
#define	PIS_CH13_CON_PULCK_POSE	19U 
#define	PIS_CH13_CON_PULCK_MSK	BITS(PIS_CH13_CON_PULCK_POSS,PIS_CH13_CON_PULCK_POSE)

#define	PIS_CH13_CON_EDGS_POSS	16U 
#define	PIS_CH13_CON_EDGS_POSE	17U 
#define	PIS_CH13_CON_EDGS_MSK	BITS(PIS_CH13_CON_EDGS_POSS,PIS_CH13_CON_EDGS_POSE)

#define	PIS_CH13_CON_SRCS_POSS	8U 
#define	PIS_CH13_CON_SRCS_POSE	13U 
#define	PIS_CH13_CON_SRCS_MSK	BITS(PIS_CH13_CON_SRCS_POSS,PIS_CH13_CON_SRCS_POSE)

#define	PIS_CH13_CON_MSIGS_POSS	0U 
#define	PIS_CH13_CON_MSIGS_POSE	3U 
#define	PIS_CH13_CON_MSIGS_MSK	BITS(PIS_CH13_CON_MSIGS_POSS,PIS_CH13_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH14_CON register ************************/

#define	PIS_CH14_CON_SYNCSEL_POSS	24U 
#define	PIS_CH14_CON_SYNCSEL_POSE	26U 
#define	PIS_CH14_CON_SYNCSEL_MSK	BITS(PIS_CH14_CON_SYNCSEL_POSS,PIS_CH14_CON_SYNCSEL_POSE)

#define	PIS_CH14_CON_PULCK_POSS	18U 
#define	PIS_CH14_CON_PULCK_POSE	19U 
#define	PIS_CH14_CON_PULCK_MSK	BITS(PIS_CH14_CON_PULCK_POSS,PIS_CH14_CON_PULCK_POSE)

#define	PIS_CH14_CON_EDGS_POSS	16U 
#define	PIS_CH14_CON_EDGS_POSE	17U 
#define	PIS_CH14_CON_EDGS_MSK	BITS(PIS_CH14_CON_EDGS_POSS,PIS_CH14_CON_EDGS_POSE)

#define	PIS_CH14_CON_SRCS_POSS	8U 
#define	PIS_CH14_CON_SRCS_POSE	13U 
#define	PIS_CH14_CON_SRCS_MSK	BITS(PIS_CH14_CON_SRCS_POSS,PIS_CH14_CON_SRCS_POSE)

#define	PIS_CH14_CON_MSIGS_POSS	0U 
#define	PIS_CH14_CON_MSIGS_POSE	3U 
#define	PIS_CH14_CON_MSIGS_MSK	BITS(PIS_CH14_CON_MSIGS_POSS,PIS_CH14_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH15_CON register ************************/

#define	PIS_CH15_CON_SYNCSEL_POSS	24U 
#define	PIS_CH15_CON_SYNCSEL_POSE	26U 
#define	PIS_CH15_CON_SYNCSEL_MSK	BITS(PIS_CH15_CON_SYNCSEL_POSS,PIS_CH15_CON_SYNCSEL_POSE)

#define	PIS_CH15_CON_PULCK_POSS	18U 
#define	PIS_CH15_CON_PULCK_POSE	19U 
#define	PIS_CH15_CON_PULCK_MSK	BITS(PIS_CH15_CON_PULCK_POSS,PIS_CH15_CON_PULCK_POSE)

#define	PIS_CH15_CON_EDGS_POSS	16U 
#define	PIS_CH15_CON_EDGS_POSE	17U 
#define	PIS_CH15_CON_EDGS_MSK	BITS(PIS_CH15_CON_EDGS_POSS,PIS_CH15_CON_EDGS_POSE)

#define	PIS_CH15_CON_SRCS_POSS	8U 
#define	PIS_CH15_CON_SRCS_POSE	13U 
#define	PIS_CH15_CON_SRCS_MSK	BITS(PIS_CH15_CON_SRCS_POSS,PIS_CH15_CON_SRCS_POSE)

#define	PIS_CH15_CON_MSIGS_POSS	0U 
#define	PIS_CH15_CON_MSIGS_POSE	3U 
#define	PIS_CH15_CON_MSIGS_MSK	BITS(PIS_CH15_CON_MSIGS_POSS,PIS_CH15_CON_MSIGS_POSE)

/****************** Bit definition for PIS_CH_OER register ************************/

#define	PIS_CH_OER_CH3OE_POS	3U 
#define	PIS_CH_OER_CH3OE_MSK	BIT(PIS_CH_OER_CH3OE_POS)

#define	PIS_CH_OER_CH2OE_POS	2U 
#define	PIS_CH_OER_CH2OE_MSK	BIT(PIS_CH_OER_CH2OE_POS)

#define	PIS_CH_OER_CH1OE_POS	1U 
#define	PIS_CH_OER_CH1OE_MSK	BIT(PIS_CH_OER_CH1OE_POS)

#define	PIS_CH_OER_CH0OE_POS	0U 
#define	PIS_CH_OER_CH0OE_MSK	BIT(PIS_CH_OER_CH0OE_POS)

/****************** Bit definition for PIS_TAR_CON0 register ************************/

#define	PIS_TAR_CON0_TIM3_CSSBRK_SEL_POS	31U 
#define	PIS_TAR_CON0_TIM3_CSSBRK_SEL_MSK	BIT(PIS_TAR_CON0_TIM3_CSSBRK_SEL_POS)

#define	PIS_TAR_CON0_TIM3_CMPIN_SEL_POS	30U 
#define	PIS_TAR_CON0_TIM3_CMPIN_SEL_MSK	BIT(PIS_TAR_CON0_TIM3_CMPIN_SEL_POS)

#define	PIS_TAR_CON0_TIM3_BRKIN_SEL_POS	28U 
#define	PIS_TAR_CON0_TIM3_BRKIN_SEL_MSK	BIT(PIS_TAR_CON0_TIM3_BRKIN_SEL_POS)

#define	PIS_TAR_CON0_TIM3_CH4IN_SEL_POS	27U 
#define	PIS_TAR_CON0_TIM3_CH4IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM3_CH4IN_SEL_POS)

#define	PIS_TAR_CON0_TIM3_CH3IN_SEL_POS	26U 
#define	PIS_TAR_CON0_TIM3_CH3IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM3_CH3IN_SEL_POS)

#define	PIS_TAR_CON0_TIM3_CH2IN_SEL_POS	25U 
#define	PIS_TAR_CON0_TIM3_CH2IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM3_CH2IN_SEL_POS)

#define	PIS_TAR_CON0_TIM3_CH1IN_SEL_POS	24U 
#define	PIS_TAR_CON0_TIM3_CH1IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM3_CH1IN_SEL_POS)

#define	PIS_TAR_CON0_TIM2_CSSBRK_SEL_POS	23U 
#define	PIS_TAR_CON0_TIM2_CSSBRK_SEL_MSK	BIT(PIS_TAR_CON0_TIM2_CSSBRK_SEL_POS)

#define	PIS_TAR_CON0_TIM2_CMPIN_SEL_POS	22U 
#define	PIS_TAR_CON0_TIM2_CMPIN_SEL_MSK	BIT(PIS_TAR_CON0_TIM2_CMPIN_SEL_POS)

#define	PIS_TAR_CON0_TIM2_BRKIN_SEL_POS	20U 
#define	PIS_TAR_CON0_TIM2_BRKIN_SEL_MSK	BIT(PIS_TAR_CON0_TIM2_BRKIN_SEL_POS)

#define	PIS_TAR_CON0_TIM2_CH4IN_SEL_POS	19U 
#define	PIS_TAR_CON0_TIM2_CH4IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM2_CH4IN_SEL_POS)

#define	PIS_TAR_CON0_TIM2_CH3IN_SEL_POS	18U 
#define	PIS_TAR_CON0_TIM2_CH3IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM2_CH3IN_SEL_POS)

#define	PIS_TAR_CON0_TIM2_CH2IN_SEL_POS	17U 
#define	PIS_TAR_CON0_TIM2_CH2IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM2_CH2IN_SEL_POS)

#define	PIS_TAR_CON0_TIM2_CH1IN_SEL_POS	16U 
#define	PIS_TAR_CON0_TIM2_CH1IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM2_CH1IN_SEL_POS)

#define	PIS_TAR_CON0_TIM1_CSSBRK_SEL_POS	15U 
#define	PIS_TAR_CON0_TIM1_CSSBRK_SEL_MSK	BIT(PIS_TAR_CON0_TIM1_CSSBRK_SEL_POS)

#define	PIS_TAR_CON0_TIM1_CMPIN_SEL_POS	14U 
#define	PIS_TAR_CON0_TIM1_CMPIN_SEL_MSK	BIT(PIS_TAR_CON0_TIM1_CMPIN_SEL_POS)

#define	PIS_TAR_CON0_TIM1_BRKIN_SEL_POS	12U 
#define	PIS_TAR_CON0_TIM1_BRKIN_SEL_MSK	BIT(PIS_TAR_CON0_TIM1_BRKIN_SEL_POS)

#define	PIS_TAR_CON0_TIM1_CH4IN_SEL_POS	11U 
#define	PIS_TAR_CON0_TIM1_CH4IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM1_CH4IN_SEL_POS)

#define	PIS_TAR_CON0_TIM1_CH3IN_SEL_POS	10U 
#define	PIS_TAR_CON0_TIM1_CH3IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM1_CH3IN_SEL_POS)

#define	PIS_TAR_CON0_TIM1_CH2IN_SEL_POS	9U 
#define	PIS_TAR_CON0_TIM1_CH2IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM1_CH2IN_SEL_POS)

#define	PIS_TAR_CON0_TIM1_CH1IN_SEL_POS	8U 
#define	PIS_TAR_CON0_TIM1_CH1IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM1_CH1IN_SEL_POS)

#define	PIS_TAR_CON0_TIM0_CSSBRK_SEL_POS	7U 
#define	PIS_TAR_CON0_TIM0_CSSBRK_SEL_MSK	BIT(PIS_TAR_CON0_TIM0_CSSBRK_SEL_POS)

#define	PIS_TAR_CON0_TIM0_CMPIN_SEL_POS	6U 
#define	PIS_TAR_CON0_TIM0_CMPIN_SEL_MSK	BIT(PIS_TAR_CON0_TIM0_CMPIN_SEL_POS)

#define	PIS_TAR_CON0_TIM0_BRKIN_SEL_POS	4U 
#define	PIS_TAR_CON0_TIM0_BRKIN_SEL_MSK	BIT(PIS_TAR_CON0_TIM0_BRKIN_SEL_POS)

#define	PIS_TAR_CON0_TIM0_CH4IN_SEL_POS	3U 
#define	PIS_TAR_CON0_TIM0_CH4IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM0_CH4IN_SEL_POS)

#define	PIS_TAR_CON0_TIM0_CH3IN_SEL_POS	2U 
#define	PIS_TAR_CON0_TIM0_CH3IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM0_CH3IN_SEL_POS)

#define	PIS_TAR_CON0_TIM0_CH2IN_SEL_POS	1U 
#define	PIS_TAR_CON0_TIM0_CH2IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM0_CH2IN_SEL_POS)

#define	PIS_TAR_CON0_TIM0_CH1IN_SEL_POS	0U 
#define	PIS_TAR_CON0_TIM0_CH1IN_SEL_MSK	BIT(PIS_TAR_CON0_TIM0_CH1IN_SEL_POS)

/****************** Bit definition for PIS_TAR_CON1 register ************************/

#define	PIS_TAR_CON1_SPI1_CLK_SEL_POS	15U 
#define	PIS_TAR_CON1_SPI1_CLK_SEL_MSK	BIT(PIS_TAR_CON1_SPI1_CLK_SEL_POS)

#define	PIS_TAR_CON1_SPI1_RX_SEL_POS	14U 
#define	PIS_TAR_CON1_SPI1_RX_SEL_MSK	BIT(PIS_TAR_CON1_SPI1_RX_SEL_POS)

#define	PIS_TAR_CON1_SPI0_CLK_SEL_POS	13U 
#define	PIS_TAR_CON1_SPI0_CLK_SEL_MSK	BIT(PIS_TAR_CON1_SPI0_CLK_SEL_POS)

#define	PIS_TAR_CON1_SPI0_RX_SEL_POS	12U 
#define	PIS_TAR_CON1_SPI0_RX_SEL_MSK	BIT(PIS_TAR_CON1_SPI0_RX_SEL_POS)

#define	PIS_TAR_CON1_UART2_RXD_SEL_POS	2U 
#define	PIS_TAR_CON1_UART2_RXD_SEL_MSK	BIT(PIS_TAR_CON1_UART2_RXD_SEL_POS)

#define	PIS_TAR_CON1_UART1_RXD_SEL_POS	1U 
#define	PIS_TAR_CON1_UART1_RXD_SEL_MSK	BIT(PIS_TAR_CON1_UART1_RXD_SEL_POS)

#define	PIS_TAR_CON1_UART0_RXD_SEL_POS	0U 
#define	PIS_TAR_CON1_UART0_RXD_SEL_MSK	BIT(PIS_TAR_CON1_UART0_RXD_SEL_POS)

/****************** Bit definition for PIS_TXMCR register ************************/

#define	PIS_UART0_TXMCR_TXMLVLS_POS	8U 
#define	PIS_UART0_TXMCR_TXMLVLS_MSK	BIT(PIS_UART0_TXMCR_TXMLVLS_POS)

#define	PIS_UART0_TXMCR_TXMSS_POSS	4U 
#define	PIS_UART0_TXMCR_TXMSS_POSE	7U 
#define	PIS_UART0_TXMCR_TXMSS_MSK	BITS(PIS_UART0_TXMCR_TXMSS_POSS,PIS_UART0_TXMCR_TXMSS_POSE)

#define	PIS_UART0_TXMCR_TXSIGS_POSS	0U 
#define	PIS_UART0_TXMCR_TXSIGS_POSE	3U 
#define	PIS_UART0_TXMCR_TXSIGS_MSK	BITS(PIS_UART0_TXMCR_TXSIGS_POSS,PIS_UART0_TXMCR_TXSIGS_POSE)

/****************** Bit definition for PIS_TXMCR register ************************/

#define	PIS_UART1_TXMCR_TXMLVLS_POS	8U 
#define	PIS_UART1_TXMCR_TXMLVLS_MSK	BIT(PIS_UART0_TXMCR_TXMLVLS_POS)

#define	PIS_UART1_TXMCR_TXMSS_POSS	4U 
#define	PIS_UART1_TXMCR_TXMSS_POSE	7U 
#define	PIS_UART1_TXMCR_TXMSS_MSK	BITS(PIS_UART1_TXMCR_TXMSS_POSS,PIS_UART1_TXMCR_TXMSS_POSE)

#define	PIS_UART1_TXMCR_TXSIGS_POSS	0U 
#define	PIS_UART1_TXMCR_TXSIGS_POSE	3U 
#define	PIS_UART1_TXMCR_TXSIGS_MSK	BITS(PIS_UART1_TXMCR_TXSIGS_POSS,PIS_UART1_TXMCR_TXSIGS_POSE)

/****************** Bit definition for PIS_TXMCR register ************************/

#define	PIS_UART2_TXMCR_TXMLVLS_POS	8U 
#define	PIS_UART2_TXMCR_TXMLVLS_MSK	BIT(PIS_UART2_TXMCR_TXMLVLS_POS)

#define	PIS_UART2_TXMCR_TXMSS_POSS	4U 
#define	PIS_UART2_TXMCR_TXMSS_POSE	7U 
#define	PIS_UART2_TXMCR_TXMSS_MSK	BITS(PIS_UART2_TXMCR_TXMSS_POSS,PIS_UART2_TXMCR_TXMSS_POSE)

#define	PIS_UART2_TXMCR_TXSIGS_POSS	0U 
#define	PIS_UART2_TXMCR_TXSIGS_POSE	3U 
#define	PIS_UART2_TXMCR_TXSIGS_MSK	BITS(PIS_UART2_TXMCR_TXSIGS_POSS,PIS_UART2_TXMCR_TXSIGS_POSE)

typedef struct
{
	__IO uint32_t CH_CON[16];
	__IO uint32_t CH_OER;
	__IO uint32_t TAR_CON0;
	__IO uint32_t TAR_CON1;
	uint32_t RESERVED0[5] ;
	__IO uint32_t UART0_TXMCR;
	__IO uint32_t UART1_TXMCR;
	__IO uint32_t UART2_TXMCR;
} PIS_TypeDef;





#endif
