/**
  **************************************************************************************
  * @file    REG_RMU.h
  * @brief   RMU Head File
  *
  * @version V0.01
  * @data    8/24/2020
  * @author  Eastsoft MCU Software Team
  * @note
  *
  * Copyright (C) 2018 Shanghai Eastsoft Microelectronics Co., Ltd. ALL rights reserved.
  *
  **************************************************************************************
  */

#ifndef __RMU_H__
#define __RMU_H__


/******************************************************************************/
/*                              设备特殊寄存器结构定义                        */
/******************************************************************************/

/*   允许匿名结构和匿名联合    */
 

/****************** Bit definition for RMU_CSR register ************************/

#define	RMU_CSR_BOR09VS_POSS	12U 
#define	RMU_CSR_BOR09VS_POSE	15U 
#define	RMU_CSR_BOR09VS_MSK	BITS(RMU_CSR_BOR09VS_POSS,RMU_CSR_BOR09VS_POSE)

#define	RMU_CSR_BOR09EN_POS	8U 
#define	RMU_CSR_BOR09EN_MSK	BIT(RMU_CSR_BOR09EN_POS)

#define	RMU_CSR_BOR33VS_POSS	4U 
#define	RMU_CSR_BOR33VS_POSE	7U 
#define	RMU_CSR_BOR33VS_MSK	BITS(RMU_CSR_BOR33VS_POSS,RMU_CSR_BOR33VS_POSE)

#define	RMU_CSR_BORFLT_POSS	1U 
#define	RMU_CSR_BORFLT_POSE	3U 
#define	RMU_CSR_BORFLT_MSK	BITS(RMU_CSR_BORFLT_POSS,RMU_CSR_BORFLT_POSE)

#define	RMU_CSR_BOR33EN_POS	0U 
#define	RMU_CSR_BOR33EN_MSK	BIT(RMU_CSR_BOR33EN_POS)

/****************** Bit definition for RMU_RSTSR register ************************/

#define	RMU_RSTSR_CFGERR_POS	16U 
#define	RMU_RSTSR_CFGERR_MSK	BIT(RMU_RSTSR_CFGERR_POS)

#define	RMU_RSTSR_CFG_WORD_POS	10U 
#define	RMU_RSTSR_CFG_WORD_MSK	BIT(RMU_RSTSR_CFG_WORD_POS)

#define	RMU_RSTSR_CPU_POS	9U 
#define	RMU_RSTSR_CPU_MSK	BIT(RMU_RSTSR_CPU_POS)

#define	RMU_RSTSR_MCU_POS	8U 
#define	RMU_RSTSR_MCU_MSK	BIT(RMU_RSTSR_MCU_POS)

#define	RMU_RSTSR_CHIP_POS	7U 
#define	RMU_RSTSR_CHIP_MSK	BIT(RMU_RSTSR_CHIP_POS)

#define	RMU_RSTSR_LOCKUP_POS	6U 
#define	RMU_RSTSR_LOCKUP_MSK	BIT(RMU_RSTSR_LOCKUP_POS)

#define	RMU_RSTSR_WWDTF_POS	5U 
#define	RMU_RSTSR_WWDTF_MSK	BIT(RMU_RSTSR_WWDTF_POS)

#define	RMU_RSTSR_IWDTF_POS	4U 
#define	RMU_RSTSR_IWDTF_MSK	BIT(RMU_RSTSR_IWDTF_POS)

#define	RMU_RSTSR_NMRST_POS	3U 
#define	RMU_RSTSR_NMRST_MSK	BIT(RMU_RSTSR_NMRST_POS)

#define	RMU_RSTSR_BOR_POS	2U 
#define	RMU_RSTSR_BOR_MSK	BIT(RMU_RSTSR_BOR_POS)

#define	RMU_RSTSR_WAKEUP_POS	1U 
#define	RMU_RSTSR_WAKEUP_MSK	BIT(RMU_RSTSR_WAKEUP_POS)

#define	RMU_RSTSR_POR_POS	0U 
#define	RMU_RSTSR_POR_MSK	BIT(RMU_RSTSR_POR_POS)

/****************** Bit definition for RMU_CRSTSR register ************************/

#define	RMU_CRSTSR_CFG_WORD_POS	10U 
#define	RMU_CRSTSR_CFG_WORD_MSK	BIT(RMU_CRSTSR_CFG_WORD_POS)

#define	RMU_CRSTSR_CPU_POS	9U 
#define	RMU_CRSTSR_CPU_MSK	BIT(RMU_CRSTSR_CPU_POS)

#define	RMU_CRSTSR_MCU_POS	8U 
#define	RMU_CRSTSR_MCU_MSK	BIT(RMU_CRSTSR_MCU_POS)

#define	RMU_CRSTSR_CHIP_POS	7U 
#define	RMU_CRSTSR_CHIP_MSK	BIT(RMU_CRSTSR_CHIP_POS)

#define	RMU_CRSTSR_LOCKUP_POS	6U 
#define	RMU_CRSTSR_LOCKUP_MSK	BIT(RMU_CRSTSR_LOCKUP_POS)

#define	RMU_CRSTSR_WWDTC_POS	5U 
#define	RMU_CRSTSR_WWDTC_MSK	BIT(RMU_CRSTSR_WWDTC_POS)

#define	RMU_CRSTSR_IWDTC_POS	4U 
#define	RMU_CRSTSR_IWDTC_MSK	BIT(RMU_CRSTSR_IWDTC_POS)

#define	RMU_CRSTSR_NMRST_POS	3U 
#define	RMU_CRSTSR_NMRST_MSK	BIT(RMU_CRSTSR_NMRST_POS)

#define	RMU_CRSTSR_BOR_POS	2U 
#define	RMU_CRSTSR_BOR_MSK	BIT(RMU_CRSTSR_BOR_POS)

#define	RMU_CRSTSR_WAKEUP_POS	1U 
#define	RMU_CRSTSR_WAKEUP_MSK	BIT(RMU_CRSTSR_WAKEUP_POS)

#define	RMU_CRSTSR_POR_POS	0U 
#define	RMU_CRSTSR_POR_MSK	BIT(RMU_CRSTSR_POR_POS)

/****************** Bit definition for RMU_AHB1RSTR register ************************/

#define	RMU_AHB1RSTR_SM3RST_POS	8U 
#define	RMU_AHB1RSTR_SM3RST_MSK	BIT(RMU_AHB1RSTR_SM3RST_POS)

#define	RMU_AHB1RSTR_PISRST_POS	5U 
#define	RMU_AHB1RSTR_PISRST_MSK	BIT(RMU_AHB1RSTR_PISRST_POS)

#define	RMU_AHB1RSTR_TRNGRST_POS	4U 
#define	RMU_AHB1RSTR_TRNGRST_MSK	BIT(RMU_AHB1RSTR_TRNGRST_POS)

#define	RMU_AHB1RSTR_CRYPTRST_POS	3U 
#define	RMU_AHB1RSTR_CRYPTRST_MSK	BIT(RMU_AHB1RSTR_CRYPTRST_POS)

#define	RMU_AHB1RSTR_CALCRST_POS	2U 
#define	RMU_AHB1RSTR_CALCRST_MSK	BIT(RMU_AHB1RSTR_CALCRST_POS)

#define	RMU_AHB1RSTR_CRCRST_POS	1U 
#define	RMU_AHB1RSTR_CRCRST_MSK	BIT(RMU_AHB1RSTR_CRCRST_POS)

#define	RMU_AHB1RSTR_GPIORST_POS	0U 
#define	RMU_AHB1RSTR_GPIORST_MSK	BIT(RMU_AHB1RSTR_GPIORST_POS)

/****************** Bit definition for RMU_AHB2RSTR register ************************/

#define	RMU_AHB2RSTR_CPURST_POS	1U 
#define	RMU_AHB2RSTR_CPURST_MSK	BIT(RMU_AHB2RSTR_CPURST_POS)

#define	RMU_AHB2RSTR_CHIPRST_POS	0U 
#define	RMU_AHB2RSTR_CHIPRST_MSK	BIT(RMU_AHB2RSTR_CHIPRST_POS)

/****************** Bit definition for RMU_APB1RSTR register ************************/

#define	RMU_APB1RSTR_QUADRST_POS	30U 
#define	RMU_APB1RSTR_QUADRST_MSK	BIT(RMU_APB1RSTR_QUADRST_POS)

#define	RMU_APB1RSTR_KSCANRST_POS	29U 
#define	RMU_APB1RSTR_KSCANRST_MSK	BIT(RMU_APB1RSTR_KSCANRST_POS)

#define	RMU_APB1RSTR_QSPIRST_POS	28U 
#define	RMU_APB1RSTR_QSPIRST_MSK	BIT(RMU_APB1RSTR_QSPIRST_POS)

#define	RMU_APB1RSTR_PDPCMRST_POS	27U 
#define	RMU_APB1RSTR_PDPCMRST_MSK	BIT(RMU_APB1RSTR_PDPCMRST_POS)

#define	RMU_APB1RSTR_ECCRST_POS	26U 
#define	RMU_APB1RSTR_ECCRST_MSK	BIT(RMU_APB1RSTR_ECCRST_POS)

#define	RMU_APB1RSTR_TKRST_POS	23U 
#define	RMU_APB1RSTR_TKRST_MSK	BIT(RMU_APB1RSTR_TKRST_POS)

#define	RMU_APB1RSTR_ADPCMRST_POS	22U 
#define	RMU_APB1RSTR_ADPCMRST_MSK	BIT(RMU_APB1RSTR_ADPCMRST_POS)

#define	RMU_APB1RSTR_I2C1RST_POS	21U 
#define	RMU_APB1RSTR_I2C1RST_MSK	BIT(RMU_APB1RSTR_I2C1RST_POS)

#define	RMU_APB1RSTR_I2C0RST_POS	20U 
#define	RMU_APB1RSTR_I2C0RST_MSK	BIT(RMU_APB1RSTR_I2C0RST_POS)

#define	RMU_APB1RSTR_SPI1RST_POS	17U 
#define	RMU_APB1RSTR_SPI1RST_MSK	BIT(RMU_APB1RSTR_SPI1RST_POS)

#define	RMU_APB1RSTR_SPI0RST_POS	16U 
#define	RMU_APB1RSTR_SPI0RST_MSK	BIT(RMU_APB1RSTR_SPI0RST_POS)

#define	RMU_APB1RSTR_UART2RST_POS	10U 
#define	RMU_APB1RSTR_UART2RST_MSK	BIT(RMU_APB1RSTR_UART2RST_POS)

#define	RMU_APB1RSTR_UART1RST_POS	9U 
#define	RMU_APB1RSTR_UART1RST_MSK	BIT(RMU_APB1RSTR_UART1RST_POS)

#define	RMU_APB1RSTR_UART0RST_POS	8U 
#define	RMU_APB1RSTR_UART0RST_MSK	BIT(RMU_APB1RSTR_UART0RST_POS)

#define	RMU_APB1RSTR_TIM5RST_POS	5U 
#define	RMU_APB1RSTR_TIM5RST_MSK	BIT(RMU_APB1RSTR_TIM5RST_POS)

#define	RMU_APB1RSTR_TIM4RST_POS	4U 
#define	RMU_APB1RSTR_TIM4RST_MSK	BIT(RMU_APB1RSTR_TIM4RST_POS)

#define	RMU_APB1RSTR_TIM3RST_POS	3U 
#define	RMU_APB1RSTR_TIM3RST_MSK	BIT(RMU_APB1RSTR_TIM3RST_POS)

#define	RMU_APB1RSTR_TIM2RST_POS	2U 
#define	RMU_APB1RSTR_TIM2RST_MSK	BIT(RMU_APB1RSTR_TIM2RST_POS)

#define	RMU_APB1RSTR_TIM1RST_POS	1U 
#define	RMU_APB1RSTR_TIM1RST_MSK	BIT(RMU_APB1RSTR_TIM1RST_POS)

#define	RMU_APB1RSTR_TIM0RST_POS	0U 
#define	RMU_APB1RSTR_TIM0RST_MSK	BIT(RMU_APB1RSTR_TIM0RST_POS)

/****************** Bit definition for RMU_APB2RSTR register ************************/

#define	RMU_APB2RSTR_RTCRST_POS	15U 
#define	RMU_APB2RSTR_RTCRST_MSK	BIT(RMU_APB2RSTR_RTCRST_POS)

#define	RMU_APB2RSTR_IWDTRST_POS	14U 
#define	RMU_APB2RSTR_IWDTRST_MSK	BIT(RMU_APB2RSTR_IWDTRST_POS)

#define	RMU_APB2RSTR_WWDTRST_POS	12U 
#define	RMU_APB2RSTR_WWDTRST_MSK	BIT(RMU_APB2RSTR_WWDTRST_POS)

#define	RMU_APB2RSTR_ADC0RST_POS	4U 
#define	RMU_APB2RSTR_ADC0RST_MSK	BIT(RMU_APB2RSTR_ADC0RST_POS)

#define	RMU_APB2RSTR_LP16TRST_POS	0U 
#define	RMU_APB2RSTR_LP16TRST_MSK	BIT(RMU_APB2RSTR_LP16TRST_POS)

/****************** Bit definition for RMU_APB3RSTR register ************************/

#define	RMU_APB3RSTR_BLEMDMRST_POS	0U 
#define	RMU_APB3RSTR_BLEMDMRST_MSK	BIT(RMU_APB3RSTR_BLEMDMRST_POS)

/****************** Bit definition for RMU_AHB2BLERSTR register ************************/

#define	RMU_AHB2BLERSTR_LPRST_POS	2U 
#define	RMU_AHB2BLERSTR_LPRST_MSK	BIT(RMU_AHB2BLERSTR_LPRST_POS)

#define	RMU_AHB2BLERSTR_CRYPTRST_POS	1U 
#define	RMU_AHB2BLERSTR_CRYPTRST_MSK	BIT(RMU_AHB2BLERSTR_CRYPTRST_POS)

#define	RMU_AHB2BLERSTR_MASTRST_POS	0U 
#define	RMU_AHB2BLERSTR_MASTRST_MSK	BIT(RMU_AHB2BLERSTR_MASTRST_POS)

typedef struct
{
	__IO uint32_t CSR;
	uint32_t RESERVED0[3] ;
	__I uint32_t RSTSR;
	__O uint32_t CRSTSR;
	uint32_t RESERVED1[2] ;
	__O uint32_t AHB1RSTR;
	__O uint32_t AHB2RSTR;
	uint32_t RESERVED2[2] ;
	__O uint32_t APB1RSTR;
	__O uint32_t APB2RSTR;
	__O uint32_t APB3RSTR;
	__O uint32_t AHB2BLERSTR;
} RMU_TypeDef;





#endif
