/**
  **************************************************************************************
  * @file    REG_AD16C4TN.h
  * @brief   AD16C4TN Head File
  *
  * @version V0.01
  * @data    8/17/2020
  * @author  Eastsoft MCU Software Team
  * @note
  *
  * Copyright (C) 2018 Shanghai Eastsoft Microelectronics Co., Ltd. ALL rights reserved.
  *
  **************************************************************************************
  */

#ifndef __AD16C4Tn_H__
#define __AD16C4Tn_H__


/******************************************************************************/
/*                              设备特殊寄存器结构定义                        */
/******************************************************************************/

/*   允许匿名结构和匿名联合    */
 

/****************** Bit definition for TIMER_CON1 register ************************/

#define	TIMER_CON1_DBGSEL_POS	15U 
#define	TIMER_CON1_DBGSEL_MSK	BIT(TIMER_CON1_DBGSEL_POS)

#define	TIMER_CON1_OCCISS_POSS	11U 
#define	TIMER_CON1_OCCISS_POSE	13U 
#define	TIMER_CON1_OCCISS_MSK	BITS(TIMER_CON1_OCCISS_POSS,TIMER_CON1_OCCISS_POSE)

#define	TIMER_CON1_OCCISP_POS	10U 
#define	TIMER_CON1_OCCISP_MSK	BIT(TIMER_CON1_OCCISP_POS)

#define	TIMER_CON1_DFCKSEL_POSS	8U 
#define	TIMER_CON1_DFCKSEL_POSE	9U 
#define	TIMER_CON1_DFCKSEL_MSK	BITS(TIMER_CON1_DFCKSEL_POSS,TIMER_CON1_DFCKSEL_POSE)

#define	TIMER_CON1_ARPEN_POS	7U 
#define	TIMER_CON1_ARPEN_MSK	BIT(TIMER_CON1_ARPEN_POS)

#define	TIMER_CON1_CMSEL_POSS	5U 
#define	TIMER_CON1_CMSEL_POSE	6U 
#define	TIMER_CON1_CMSEL_MSK	BITS(TIMER_CON1_CMSEL_POSS,TIMER_CON1_CMSEL_POSE)

#define	TIMER_CON1_DIRSEL_POS	4U 
#define	TIMER_CON1_DIRSEL_MSK	BIT(TIMER_CON1_DIRSEL_POS)

#define	TIMER_CON1_SPMEN_POS	3U 
#define	TIMER_CON1_SPMEN_MSK	BIT(TIMER_CON1_SPMEN_POS)

#define	TIMER_CON1_UERSEL_POS	2U 
#define	TIMER_CON1_UERSEL_MSK	BIT(TIMER_CON1_UERSEL_POS)

#define	TIMER_CON1_DISUE_POS	1U 
#define	TIMER_CON1_DISUE_MSK	BIT(TIMER_CON1_DISUE_POS)

#define	TIMER_CON1_CNTEN_POS	0U 
#define	TIMER_CON1_CNTEN_MSK	BIT(TIMER_CON1_CNTEN_POS)

/****************** Bit definition for TIMER_CON2 register ************************/

#define	TIMER_CON2_OISS4_POS	14U 
#define	TIMER_CON2_OISS4_MSK	BIT(TIMER_CON2_OISS4_POS)

#define	TIMER_CON2_OISS3N_POS	13U 
#define	TIMER_CON2_OISS3N_MSK	BIT(TIMER_CON2_OISS3N_POS)

#define	TIMER_CON2_OISS3_POS	12U 
#define	TIMER_CON2_OISS3_MSK	BIT(TIMER_CON2_OISS3_POS)

#define	TIMER_CON2_OISS2N_POS	11U 
#define	TIMER_CON2_OISS2N_MSK	BIT(TIMER_CON2_OISS2N_POS)

#define	TIMER_CON2_OISS2_POS	10U 
#define	TIMER_CON2_OISS2_MSK	BIT(TIMER_CON2_OISS2_POS)

#define	TIMER_CON2_OISS1N_POS	9U 
#define	TIMER_CON2_OISS1N_MSK	BIT(TIMER_CON2_OISS1N_POS)

#define	TIMER_CON2_OISS1_POS	8U 
#define	TIMER_CON2_OISS1_MSK	BIT(TIMER_CON2_OISS1_POS)

#define	TIMER_CON2_I1FSEL_POS	7U 
#define	TIMER_CON2_I1FSEL_MSK	BIT(TIMER_CON2_I1FSEL_POS)

#define	TIMER_CON2_TRGOSEL_POSS	4U 
#define	TIMER_CON2_TRGOSEL_POSE	6U 
#define	TIMER_CON2_TRGOSEL_MSK	BITS(TIMER_CON2_TRGOSEL_POSS,TIMER_CON2_TRGOSEL_POSE)

#define	TIMER_CON2_CCDMASEL_POS	3U 
#define	TIMER_CON2_CCDMASEL_MSK	BIT(TIMER_CON2_CCDMASEL_POS)

#define	TIMER_CON2_CCUSEL_POS	2U 
#define	TIMER_CON2_CCUSEL_MSK	BIT(TIMER_CON2_CCUSEL_POS)

#define	TIMER_CON2_CCPCEN_POS	0U 
#define	TIMER_CON2_CCPCEN_MSK	BIT(TIMER_CON2_CCPCEN_POS)

/****************** Bit definition for TIMER_SMCON register ************************/

#define	TIMER_SMCON_ETPOL_POS	15U 
#define	TIMER_SMCON_ETPOL_MSK	BIT(TIMER_SMCON_ETPOL_POS)

#define	TIMER_SMCON_ECM2EN_POS	14U 
#define	TIMER_SMCON_ECM2EN_MSK	BIT(TIMER_SMCON_ECM2EN_POS)

#define	TIMER_SMCON_ETPSEL_POSS	12U 
#define	TIMER_SMCON_ETPSEL_POSE	13U 
#define	TIMER_SMCON_ETPSEL_MSK	BITS(TIMER_SMCON_ETPSEL_POSS,TIMER_SMCON_ETPSEL_POSE)

#define	TIMER_SMCON_ETFLT_POSS	8U 
#define	TIMER_SMCON_ETFLT_POSE	11U 
#define	TIMER_SMCON_ETFLT_MSK	BITS(TIMER_SMCON_ETFLT_POSS,TIMER_SMCON_ETFLT_POSE)

#define	TIMER_SMCON_MSCFG_POS	7U 
#define	TIMER_SMCON_MSCFG_MSK	BIT(TIMER_SMCON_MSCFG_POS)

#define	TIMER_SMCON_TSSEL_POSS	4U 
#define	TIMER_SMCON_TSSEL_POSE	6U 
#define	TIMER_SMCON_TSSEL_MSK	BITS(TIMER_SMCON_TSSEL_POSS,TIMER_SMCON_TSSEL_POSE)

#define	TIMER_SMCON_OCCS_POS	3U 
#define	TIMER_SMCON_OCCS_MSK	BIT(TIMER_SMCON_OCCS_POS)

#define	TIMER_SMCON_SMODS_POSS	0U 
#define	TIMER_SMCON_SMODS_POSE	2U 
#define	TIMER_SMCON_SMODS_MSK	BITS(TIMER_SMCON_SMODS_POSS,TIMER_SMCON_SMODS_POSE)

/****************** Bit definition for TIMER_IER register ************************/

#define	TIMER_IER_CC4OIT_POS	12U 
#define	TIMER_IER_CC4OIT_MSK	BIT(TIMER_IER_CC4OIT_POS)

#define	TIMER_IER_CC3OIT_POS	11U 
#define	TIMER_IER_CC3OIT_MSK	BIT(TIMER_IER_CC3OIT_POS)

#define	TIMER_IER_CC2OIT_POS	10U 
#define	TIMER_IER_CC2OIT_MSK	BIT(TIMER_IER_CC2OIT_POS)

#define	TIMER_IER_CC1OIT_POS	9U 
#define	TIMER_IER_CC1OIT_MSK	BIT(TIMER_IER_CC1OIT_POS)

#define	TIMER_IER_BRKIT_POS	7U 
#define	TIMER_IER_BRKIT_MSK	BIT(TIMER_IER_BRKIT_POS)

#define	TIMER_IER_TRGIT_POS	6U 
#define	TIMER_IER_TRGIT_MSK	BIT(TIMER_IER_TRGIT_POS)

#define	TIMER_IER_COMIT_POS	5U 
#define	TIMER_IER_COMIT_MSK	BIT(TIMER_IER_COMIT_POS)

#define	TIMER_IER_CC4IT_POS	4U 
#define	TIMER_IER_CC4IT_MSK	BIT(TIMER_IER_CC4IT_POS)

#define	TIMER_IER_CC3IT_POS	3U 
#define	TIMER_IER_CC3IT_MSK	BIT(TIMER_IER_CC3IT_POS)

#define	TIMER_IER_CC2IT_POS	2U 
#define	TIMER_IER_CC2IT_MSK	BIT(TIMER_IER_CC2IT_POS)

#define	TIMER_IER_CC1IT_POS	1U 
#define	TIMER_IER_CC1IT_MSK	BIT(TIMER_IER_CC1IT_POS)

#define	TIMER_IER_UIT_POS	0U 
#define	TIMER_IER_UIT_MSK	BIT(TIMER_IER_UIT_POS)

/****************** Bit definition for TIMER_IDR register ************************/

#define	TIMER_IDR_CC4OIT_POS	12U 
#define	TIMER_IDR_CC4OIT_MSK	BIT(TIMER_IDR_CC4OIT_POS)

#define	TIMER_IDR_CC3OIT_POS	11U 
#define	TIMER_IDR_CC3OIT_MSK	BIT(TIMER_IDR_CC3OIT_POS)

#define	TIMER_IDR_CC2OIT_POS	10U 
#define	TIMER_IDR_CC2OIT_MSK	BIT(TIMER_IDR_CC2OIT_POS)

#define	TIMER_IDR_CC1OIT_POS	9U 
#define	TIMER_IDR_CC1OIT_MSK	BIT(TIMER_IDR_CC1OIT_POS)

#define	TIMER_IDR_BRKIT_POS	7U 
#define	TIMER_IDR_BRKIT_MSK	BIT(TIMER_IDR_BRKIT_POS)

#define	TIMER_IDR_TRGIT_POS	6U 
#define	TIMER_IDR_TRGIT_MSK	BIT(TIMER_IDR_TRGIT_POS)

#define	TIMER_IDR_COMIT_POS	5U 
#define	TIMER_IDR_COMIT_MSK	BIT(TIMER_IDR_COMIT_POS)

#define	TIMER_IDR_CC4IT_POS	4U 
#define	TIMER_IDR_CC4IT_MSK	BIT(TIMER_IDR_CC4IT_POS)

#define	TIMER_IDR_CC3IT_POS	3U 
#define	TIMER_IDR_CC3IT_MSK	BIT(TIMER_IDR_CC3IT_POS)

#define	TIMER_IDR_CC2IT_POS	2U 
#define	TIMER_IDR_CC2IT_MSK	BIT(TIMER_IDR_CC2IT_POS)

#define	TIMER_IDR_CC1IT_POS	1U 
#define	TIMER_IDR_CC1IT_MSK	BIT(TIMER_IDR_CC1IT_POS)

#define	TIMER_IDR_UIT_POS	0U 
#define	TIMER_IDR_UIT_MSK	BIT(TIMER_IDR_UIT_POS)

/****************** Bit definition for TIMER_IVS register ************************/

#define	TIMER_IVS_CC4OIT_POS	12U 
#define	TIMER_IVS_CC4OIT_MSK	BIT(TIMER_IVS_CC4OIT_POS)

#define	TIMER_IVS_CC3OIT_POS	11U 
#define	TIMER_IVS_CC3OIT_MSK	BIT(TIMER_IVS_CC3OIT_POS)

#define	TIMER_IVS_CC2OIT_POS	10U 
#define	TIMER_IVS_CC2OIT_MSK	BIT(TIMER_IVS_CC2OIT_POS)

#define	TIMER_IVS_CC1OIT_POS	9U 
#define	TIMER_IVS_CC1OIT_MSK	BIT(TIMER_IVS_CC1OIT_POS)

#define	TIMER_IVS_BRKIT_POS	7U 
#define	TIMER_IVS_BRKIT_MSK	BIT(TIMER_IVS_BRKIT_POS)

#define	TIMER_IVS_TRGIT_POS	6U 
#define	TIMER_IVS_TRGIT_MSK	BIT(TIMER_IVS_TRGIT_POS)

#define	TIMER_IVS_COMIT_POS	5U 
#define	TIMER_IVS_COMIT_MSK	BIT(TIMER_IVS_COMIT_POS)

#define	TIMER_IVS_CC4IT_POS	4U 
#define	TIMER_IVS_CC4IT_MSK	BIT(TIMER_IVS_CC4IT_POS)

#define	TIMER_IVS_CC3IT_POS	3U 
#define	TIMER_IVS_CC3IT_MSK	BIT(TIMER_IVS_CC3IT_POS)

#define	TIMER_IVS_CC2IT_POS	2U 
#define	TIMER_IVS_CC2IT_MSK	BIT(TIMER_IVS_CC2IT_POS)

#define	TIMER_IVS_CC1IT_POS	1U 
#define	TIMER_IVS_CC1IT_MSK	BIT(TIMER_IVS_CC1IT_POS)

#define	TIMER_IVS_UIT_POS	0U 
#define	TIMER_IVS_UIT_MSK	BIT(TIMER_IVS_UIT_POS)

/****************** Bit definition for TIMER_RIF register ************************/

#define	TIMER_RIF_CH4OVIF_POS	12U 
#define	TIMER_RIF_CH4OVIF_MSK	BIT(TIMER_RIF_CH4OVIF_POS)

#define	TIMER_RIF_CH3OVIF_POS	11U 
#define	TIMER_RIF_CH3OVIF_MSK	BIT(TIMER_RIF_CH3OVIF_POS)

#define	TIMER_RIF_CH2OVIF_POS	10U 
#define	TIMER_RIF_CH2OVIF_MSK	BIT(TIMER_RIF_CH2OVIF_POS)

#define	TIMER_RIF_CH1OVIF_POS	9U 
#define	TIMER_RIF_CH1OVIF_MSK	BIT(TIMER_RIF_CH1OVIF_POS)

#define	TIMER_RIF_BRKIF_POS	7U 
#define	TIMER_RIF_BRKIF_MSK	BIT(TIMER_RIF_BRKIF_POS)

#define	TIMER_RIF_TRGIF_POS	6U 
#define	TIMER_RIF_TRGIF_MSK	BIT(TIMER_RIF_TRGIF_POS)

#define	TIMER_RIF_COMIF_POS	5U 
#define	TIMER_RIF_COMIF_MSK	BIT(TIMER_RIF_COMIF_POS)

#define	TIMER_RIF_CH4CCIF_POS	4U 
#define	TIMER_RIF_CH4CCIF_MSK	BIT(TIMER_RIF_CH4CCIF_POS)

#define	TIMER_RIF_CH3CCIF_POS	3U 
#define	TIMER_RIF_CH3CCIF_MSK	BIT(TIMER_RIF_CH3CCIF_POS)

#define	TIMER_RIF_CH2CCIF_POS	2U 
#define	TIMER_RIF_CH2CCIF_MSK	BIT(TIMER_RIF_CH2CCIF_POS)

#define	TIMER_RIF_CH1CCIF_POS	1U 
#define	TIMER_RIF_CH1CCIF_MSK	BIT(TIMER_RIF_CH1CCIF_POS)

#define	TIMER_RIF_UEVTIF_POS	0U 
#define	TIMER_RIF_UEVTIF_MSK	BIT(TIMER_RIF_UEVTIF_POS)

/****************** Bit definition for TIMER_IFM register ************************/

#define	TIMER_IFM_CH4OVIM_POS	12U 
#define	TIMER_IFM_CH4OVIM_MSK	BIT(TIMER_IFM_CH4OVIM_POS)

#define	TIMER_IFM_CH3OVIM_POS	11U 
#define	TIMER_IFM_CH3OVIM_MSK	BIT(TIMER_IFM_CH3OVIM_POS)

#define	TIMER_IFM_CH2OVIM_POS	10U 
#define	TIMER_IFM_CH2OVIM_MSK	BIT(TIMER_IFM_CH2OVIM_POS)

#define	TIMER_IFM_CH1OVIM_POS	9U 
#define	TIMER_IFM_CH1OVIM_MSK	BIT(TIMER_IFM_CH1OVIM_POS)

#define	TIMER_IFM_BRKIM_POS	7U 
#define	TIMER_IFM_BRKIM_MSK	BIT(TIMER_IFM_BRKIM_POS)

#define	TIMER_IFM_TRGIM_POS	6U 
#define	TIMER_IFM_TRGIM_MSK	BIT(TIMER_IFM_TRGIM_POS)

#define	TIMER_IFM_COMIM_POS	5U 
#define	TIMER_IFM_COMIM_MSK	BIT(TIMER_IFM_COMIM_POS)

#define	TIMER_IFM_CH4CCIM_POS	4U 
#define	TIMER_IFM_CH4CCIM_MSK	BIT(TIMER_IFM_CH4CCIM_POS)

#define	TIMER_IFM_CH3CCIM_POS	3U 
#define	TIMER_IFM_CH3CCIM_MSK	BIT(TIMER_IFM_CH3CCIM_POS)

#define	TIMER_IFM_CH2CCIM_POS	2U 
#define	TIMER_IFM_CH2CCIM_MSK	BIT(TIMER_IFM_CH2CCIM_POS)

#define	TIMER_IFM_CH1CCIM_POS	1U 
#define	TIMER_IFM_CH1CCIM_MSK	BIT(TIMER_IFM_CH1CCIM_POS)

#define	TIMER_IFM_UEVTIM_POS	0U 
#define	TIMER_IFM_UEVTIM_MSK	BIT(TIMER_IFM_UEVTIM_POS)

/****************** Bit definition for TIMER_ICR register ************************/

#define	TIMER_ICR_CH4OVIC_POS	12U 
#define	TIMER_ICR_CH4OVIC_MSK	BIT(TIMER_ICR_CH4OVIC_POS)

#define	TIMER_ICR_CH3OVIC_POS	11U 
#define	TIMER_ICR_CH3OVIC_MSK	BIT(TIMER_ICR_CH3OVIC_POS)

#define	TIMER_ICR_CH2OVIC_POS	10U 
#define	TIMER_ICR_CH2OVIC_MSK	BIT(TIMER_ICR_CH2OVIC_POS)

#define	TIMER_ICR_CH1OVIC_POS	9U 
#define	TIMER_ICR_CH1OVIC_MSK	BIT(TIMER_ICR_CH1OVIC_POS)

#define	TIMER_ICR_BRKIC_POS	7U 
#define	TIMER_ICR_BRKIC_MSK	BIT(TIMER_ICR_BRKIC_POS)

#define	TIMER_ICR_TRGIC_POS	6U 
#define	TIMER_ICR_TRGIC_MSK	BIT(TIMER_ICR_TRGIC_POS)

#define	TIMER_ICR_COMIC_POS	5U 
#define	TIMER_ICR_COMIC_MSK	BIT(TIMER_ICR_COMIC_POS)

#define	TIMER_ICR_CH4CCIC_POS	4U 
#define	TIMER_ICR_CH4CCIC_MSK	BIT(TIMER_ICR_CH4CCIC_POS)

#define	TIMER_ICR_CH3CCIC_POS	3U 
#define	TIMER_ICR_CH3CCIC_MSK	BIT(TIMER_ICR_CH3CCIC_POS)

#define	TIMER_ICR_CH2CCIC_POS	2U 
#define	TIMER_ICR_CH2CCIC_MSK	BIT(TIMER_ICR_CH2CCIC_POS)

#define	TIMER_ICR_CH1CCIC_POS	1U 
#define	TIMER_ICR_CH1CCIC_MSK	BIT(TIMER_ICR_CH1CCIC_POS)

#define	TIMER_ICR_UEVTIC_POS	0U 
#define	TIMER_ICR_UEVTIC_MSK	BIT(TIMER_ICR_UEVTIC_POS)

/****************** Bit definition for TIMER_SGE register ************************/

#define	TIMER_SGE_SGBRK_POS	7U 
#define	TIMER_SGE_SGBRK_MSK	BIT(TIMER_SGE_SGBRK_POS)

#define	TIMER_SGE_SGTRG_POS	6U 
#define	TIMER_SGE_SGTRG_MSK	BIT(TIMER_SGE_SGTRG_POS)

#define	TIMER_SGE_SGCOM_POS	5U 
#define	TIMER_SGE_SGCOM_MSK	BIT(TIMER_SGE_SGCOM_POS)

#define	TIMER_SGE_SGCC4E_POS	4U 
#define	TIMER_SGE_SGCC4E_MSK	BIT(TIMER_SGE_SGCC4E_POS)

#define	TIMER_SGE_SGCC3E_POS	3U 
#define	TIMER_SGE_SGCC3E_MSK	BIT(TIMER_SGE_SGCC3E_POS)

#define	TIMER_SGE_SGCC2E_POS	2U 
#define	TIMER_SGE_SGCC2E_MSK	BIT(TIMER_SGE_SGCC2E_POS)

#define	TIMER_SGE_SGCC1E_POS	1U 
#define	TIMER_SGE_SGCC1E_MSK	BIT(TIMER_SGE_SGCC1E_POS)

#define	TIMER_SGE_SGU_POS	0U 
#define	TIMER_SGE_SGU_MSK	BIT(TIMER_SGE_SGU_POS)

/****************** Bit definition for TIMER_CHMR1 register ************************/

/* OUT */

#define	TIMER_CHMR1_CH2OCLREN_POS	15U 
#define	TIMER_CHMR1_CH2OCLREN_MSK	BIT(TIMER_CHMR1_CH2OCLREN_POS)

#define	TIMER_CHMR1_CH2OMOD_POSS	12U 
#define	TIMER_CHMR1_CH2OMOD_POSE	14U 
#define	TIMER_CHMR1_CH2OMOD_MSK	BITS(TIMER_CHMR1_CH2OMOD_POSS,TIMER_CHMR1_CH2OMOD_POSE)

#define	TIMER_CHMR1_CH2OPREN_POS	11U 
#define	TIMER_CHMR1_CH2OPREN_MSK	BIT(TIMER_CHMR1_CH2OPREN_POS)

#define	TIMER_CHMR1_CH2OHSEN_POS	10U 
#define	TIMER_CHMR1_CH2OHSEN_MSK	BIT(TIMER_CHMR1_CH2OHSEN_POS)

#define	TIMER_CHMR1_CC2SSEL_POSS	8U 
#define	TIMER_CHMR1_CC2SSEL_POSE	9U 
#define	TIMER_CHMR1_CC2SSEL_MSK	BITS(TIMER_CHMR1_CC2SSEL_POSS,TIMER_CHMR1_CC2SSEL_POSE)

#define	TIMER_CHMR1_CH1OCLREN_POS	7U 
#define	TIMER_CHMR1_CH1OCLREN_MSK	BIT(TIMER_CHMR1_CH1OCLREN_POS)

#define	TIMER_CHMR1_CH1OMOD_POSS	4U 
#define	TIMER_CHMR1_CH1OMOD_POSE	6U 
#define	TIMER_CHMR1_CH1OMOD_MSK	BITS(TIMER_CHMR1_CH1OMOD_POSS,TIMER_CHMR1_CH1OMOD_POSE)

#define	TIMER_CHMR1_CH1OPREN_POS	3U 
#define	TIMER_CHMR1_CH1OPREN_MSK	BIT(TIMER_CHMR1_CH1OPREN_POS)

#define	TIMER_CHMR1_CH1OHSEN_POS	2U 
#define	TIMER_CHMR1_CH1OHSEN_MSK	BIT(TIMER_CHMR1_CH1OHSEN_POS)

#define	TIMER_CHMR1_CC1SSEL_POSS	0U 
#define	TIMER_CHMR1_CC1SSEL_POSE	1U 
#define	TIMER_CHMR1_CC1SSEL_MSK	BITS(TIMER_CHMR1_CC1SSEL_POSS,TIMER_CHMR1_CC1SSEL_POSE)

/* IN */

#define	TIMER_CHMR1_I2FLT_POSS	12U 
#define	TIMER_CHMR1_I2FLT_POSE	15U 
#define	TIMER_CHMR1_I2FLT_MSK	BITS(TIMER_CHMR1_I2FLT_POSS,TIMER_CHMR1_I2FLT_POSE)

#define	TIMER_CHMR1_IC2PRES_POSS	10U 
#define	TIMER_CHMR1_IC2PRES_POSE	11U 
#define	TIMER_CHMR1_IC2PRES_MSK	BITS(TIMER_CHMR1_IC2PRES_POSS,TIMER_CHMR1_IC2PRES_POSE)

#define	TIMER_CHMR1_CC2SSEL_POSS	8U 
#define	TIMER_CHMR1_CC2SSEL_POSE	9U 
#define	TIMER_CHMR1_CC2SSEL_MSK	BITS(TIMER_CHMR1_CC2SSEL_POSS,TIMER_CHMR1_CC2SSEL_POSE)

#define	TIMER_CHMR1_I1FLT_POSS	4U 
#define	TIMER_CHMR1_I1FLT_POSE	7U 
#define	TIMER_CHMR1_I1FLT_MSK	BITS(TIMER_CHMR1_I1FLT_POSS,TIMER_CHMR1_I1FLT_POSE)

#define	TIMER_CHMR1_IC1PRES_POSS	2U 
#define	TIMER_CHMR1_IC1PRES_POSE	3U 
#define	TIMER_CHMR1_IC1PRES_MSK	BITS(TIMER_CHMR1_IC1PRES_POSS,TIMER_CHMR1_IC1PRES_POSE)

#define	TIMER_CHMR1_CC1SSEL_POSS	0U 
#define	TIMER_CHMR1_CC1SSEL_POSE	1U 
#define	TIMER_CHMR1_CC1SSEL_MSK	BITS(TIMER_CHMR1_CC1SSEL_POSS,TIMER_CHMR1_CC1SSEL_POSE)

/****************** Bit definition for TIMER_CHMR2 register ************************/

/* OUT */

#define	TIMER_CHMR2_CH4OCLREN_POS	15U 
#define	TIMER_CHMR2_CH4OCLREN_MSK	BIT(TIMER_CHMR2_CH4OCLREN_POS)

#define	TIMER_CHMR2_CH4OMOD_POSS	12U 
#define	TIMER_CHMR2_CH4OMOD_POSE	14U 
#define	TIMER_CHMR2_CH4OMOD_MSK	BITS(TIMER_CHMR2_CH4OMOD_POSS,TIMER_CHMR2_CH4OMOD_POSE)

#define	TIMER_CHMR2_CH4OPREN_POS	11U 
#define	TIMER_CHMR2_CH4OPREN_MSK	BIT(TIMER_CHMR2_CH4OPREN_POS)

#define	TIMER_CHMR2_CH4OHSEN_POS	10U 
#define	TIMER_CHMR2_CH4OHSEN_MSK	BIT(TIMER_CHMR2_CH4OHSEN_POS)

#define	TIMER_CHMR2_CC4SSEL_POSS	8U 
#define	TIMER_CHMR2_CC4SSEL_POSE	9U 
#define	TIMER_CHMR2_CC4SSEL_MSK	BITS(TIMER_CHMR2_CC4SSEL_POSS,TIMER_CHMR2_CC4SSEL_POSE)

#define	TIMER_CHMR2_CH3OCLREN_POS	7U 
#define	TIMER_CHMR2_CH3OCLREN_MSK	BIT(TIMER_CHMR2_CH3OCLREN_POS)

#define	TIMER_CHMR2_CH3OMOD_POSS	4U 
#define	TIMER_CHMR2_CH3OMOD_POSE	6U 
#define	TIMER_CHMR2_CH3OMOD_MSK	BITS(TIMER_CHMR2_CH3OMOD_POSS,TIMER_CHMR2_CH3OMOD_POSE)

#define	TIMER_CHMR2_CH3OPREN_POS	3U 
#define	TIMER_CHMR2_CH3OPREN_MSK	BIT(TIMER_CHMR2_CH3OPREN_POS)

#define	TIMER_CHMR2_CH3OHSEN_POS	2U 
#define	TIMER_CHMR2_CH3OHSEN_MSK	BIT(TIMER_CHMR2_CH3OHSEN_POS)

#define	TIMER_CHMR2_CC3SSEL_POSS	0U 
#define	TIMER_CHMR2_CC3SSEL_POSE	1U 
#define	TIMER_CHMR2_CC3SSEL_MSK	BITS(TIMER_CHMR2_CC3SSEL_POSS,TIMER_CHMR2_CC3SSEL_POSE)

/* IN */

#define	TIMER_CHMR2_I4FLT_POSS	12U 
#define	TIMER_CHMR2_I4FLT_POSE	15U 
#define	TIMER_CHMR2_I4FLT_MSK	BITS(TIMER_CHMR2_I4FLT_POSS,TIMER_CHMR2_I4FLT_POSE)

#define	TIMER_CHMR2_IC4PRES_POSS	10U 
#define	TIMER_CHMR2_IC4PRES_POSE	11U 
#define	TIMER_CHMR2_IC4PRES_MSK	BITS(TIMER_CHMR2_IC4PRES_POSS,TIMER_CHMR2_IC4PRES_POSE)

#define	TIMER_CHMR2_CC4SSEL_POSS	8U 
#define	TIMER_CHMR2_CC4SSEL_POSE	9U 
#define	TIMER_CHMR2_CC4SSEL_MSK	BITS(TIMER_CHMR2_CC4SSEL_POSS,TIMER_CHMR2_CC4SSEL_POSE)

#define	TIMER_CHMR2_I3FLT_POSS	4U 
#define	TIMER_CHMR2_I3FLT_POSE	7U 
#define	TIMER_CHMR2_I3FLT_MSK	BITS(TIMER_CHMR2_I3FLT_POSS,TIMER_CHMR2_I3FLT_POSE)

#define	TIMER_CHMR2_IC3PRES_POSS	2U 
#define	TIMER_CHMR2_IC3PRES_POSE	3U 
#define	TIMER_CHMR2_IC3PRES_MSK	BITS(TIMER_CHMR2_IC3PRES_POSS,TIMER_CHMR2_IC3PRES_POSE)

#define	TIMER_CHMR2_CC3SSEL_POSS	0U 
#define	TIMER_CHMR2_CC3SSEL_POSE	1U 
#define	TIMER_CHMR2_CC3SSEL_MSK	BITS(TIMER_CHMR2_CC3SSEL_POSS,TIMER_CHMR2_CC3SSEL_POSE)

/****************** Bit definition for TIMER_CCEP register ************************/

#define	TIMER_CCEP_CC4POL_POS	13U 
#define	TIMER_CCEP_CC4POL_MSK	BIT(TIMER_CCEP_CC4POL_POS)

#define	TIMER_CCEP_CC4EN_POS	12U 
#define	TIMER_CCEP_CC4EN_MSK	BIT(TIMER_CCEP_CC4EN_POS)

#define	TIMER_CCEP_CC3NPOL_POS	11U 
#define	TIMER_CCEP_CC3NPOL_MSK	BIT(TIMER_CCEP_CC3NPOL_POS)

#define	TIMER_CCEP_CC3NEN_POS	10U 
#define	TIMER_CCEP_CC3NEN_MSK	BIT(TIMER_CCEP_CC3NEN_POS)

#define	TIMER_CCEP_CC3POL_POS	9U 
#define	TIMER_CCEP_CC3POL_MSK	BIT(TIMER_CCEP_CC3POL_POS)

#define	TIMER_CCEP_CC3EN_POS	8U 
#define	TIMER_CCEP_CC3EN_MSK	BIT(TIMER_CCEP_CC3EN_POS)

#define	TIMER_CCEP_CC2NPOL_POS	7U 
#define	TIMER_CCEP_CC2NPOL_MSK	BIT(TIMER_CCEP_CC2NPOL_POS)

#define	TIMER_CCEP_CC2NEN_POS	6U 
#define	TIMER_CCEP_CC2NEN_MSK	BIT(TIMER_CCEP_CC2NEN_POS)

#define	TIMER_CCEP_CC2POL_POS	5U 
#define	TIMER_CCEP_CC2POL_MSK	BIT(TIMER_CCEP_CC2POL_POS)

#define	TIMER_CCEP_CC2EN_POS	4U 
#define	TIMER_CCEP_CC2EN_MSK	BIT(TIMER_CCEP_CC2EN_POS)

#define	TIMER_CCEP_CC1NPOL_POS	3U 
#define	TIMER_CCEP_CC1NPOL_MSK	BIT(TIMER_CCEP_CC1NPOL_POS)

#define	TIMER_CCEP_CC1NEN_POS	2U 
#define	TIMER_CCEP_CC1NEN_MSK	BIT(TIMER_CCEP_CC1NEN_POS)

#define	TIMER_CCEP_CC1POL_POS	1U 
#define	TIMER_CCEP_CC1POL_MSK	BIT(TIMER_CCEP_CC1POL_POS)

#define	TIMER_CCEP_CC1EN_POS	0U 
#define	TIMER_CCEP_CC1EN_MSK	BIT(TIMER_CCEP_CC1EN_POS)

/****************** Bit definition for TIMER_COUNT register ************************/

#define	TIMER_COUNT_CNTV_POSS	0U 
#define	TIMER_COUNT_CNTV_POSE	15U 
#define	TIMER_COUNT_CNTV_MSK	BITS(TIMER_COUNT_CNTV_POSS,TIMER_COUNT_CNTV_POSE)

/****************** Bit definition for TIMER_PRES register ************************/

#define	TIMER_PRES_PSCV_POSS	0U 
#define	TIMER_PRES_PSCV_POSE	15U 
#define	TIMER_PRES_PSCV_MSK	BITS(TIMER_PRES_PSCV_POSS,TIMER_PRES_PSCV_POSE)

/****************** Bit definition for TIMER_AR register ************************/

#define	TIMER_AR_ARRV_POSS	0U 
#define	TIMER_AR_ARRV_POSE	15U 
#define	TIMER_AR_ARRV_MSK	BITS(TIMER_AR_ARRV_POSS,TIMER_AR_ARRV_POSE)

/****************** Bit definition for TIMER_REPAR register ************************/

#define	TIMER_REPAR_REPV_POSS	0U 
#define	TIMER_REPAR_REPV_POSE	7U 
#define	TIMER_REPAR_REPV_MSK	BITS(TIMER_REPAR_REPV_POSS,TIMER_REPAR_REPV_POSE)

/****************** Bit definition for TIMER_CCVAL1 register ************************/

#define	TIMER_CCVAL1_CCRV1_POSS	0U 
#define	TIMER_CCVAL1_CCRV1_POSE	15U 
#define	TIMER_CCVAL1_CCRV1_MSK	BITS(TIMER_CCVAL1_CCRV1_POSS,TIMER_CCVAL1_CCRV1_POSE)

/****************** Bit definition for TIMER_CCVAL2 register ************************/

#define	TIMER_CCVAL2_CCRV2_POSS	0U 
#define	TIMER_CCVAL2_CCRV2_POSE	15U 
#define	TIMER_CCVAL2_CCRV2_MSK	BITS(TIMER_CCVAL2_CCRV2_POSS,TIMER_CCVAL2_CCRV2_POSE)

/****************** Bit definition for TIMER_CCVAL3 register ************************/

#define	TIMER_CCVAL3_CCRV3_POSS	0U 
#define	TIMER_CCVAL3_CCRV3_POSE	15U 
#define	TIMER_CCVAL3_CCRV3_MSK	BITS(TIMER_CCVAL3_CCRV3_POSS,TIMER_CCVAL3_CCRV3_POSE)

/****************** Bit definition for TIMER_CCVAL4 register ************************/

#define	TIMER_CCVAL4_CCRV4_POSS	0U 
#define	TIMER_CCVAL4_CCRV4_POSE	15U 
#define	TIMER_CCVAL4_CCRV4_MSK	BITS(TIMER_CCVAL4_CCRV4_POSS,TIMER_CCVAL4_CCRV4_POSE)

/****************** Bit definition for TIMER_BDCFG register ************************/

#define	TIMER_BDCFG_GOEN_POS	15U 
#define	TIMER_BDCFG_GOEN_MSK	BIT(TIMER_BDCFG_GOEN_POS)

#define	TIMER_BDCFG_AOEN_POS	14U 
#define	TIMER_BDCFG_AOEN_MSK	BIT(TIMER_BDCFG_AOEN_POS)

#define	TIMER_BDCFG_BRKP_POS	13U 
#define	TIMER_BDCFG_BRKP_MSK	BIT(TIMER_BDCFG_BRKP_POS)

#define	TIMER_BDCFG_BRKEN_POS	12U 
#define	TIMER_BDCFG_BRKEN_MSK	BIT(TIMER_BDCFG_BRKEN_POS)

#define	TIMER_BDCFG_OFFSSR_POS	11U 
#define	TIMER_BDCFG_OFFSSR_MSK	BIT(TIMER_BDCFG_OFFSSR_POS)

#define	TIMER_BDCFG_OFFSSI_POS	10U 
#define	TIMER_BDCFG_OFFSSI_MSK	BIT(TIMER_BDCFG_OFFSSI_POS)

#define	TIMER_BDCFG_LOCKLVL_POSS	8U 
#define	TIMER_BDCFG_LOCKLVL_POSE	9U 
#define	TIMER_BDCFG_LOCKLVL_MSK	BITS(TIMER_BDCFG_LOCKLVL_POSS,TIMER_BDCFG_LOCKLVL_POSE)

#define	TIMER_BDCFG_DT_POSS	0U 
#define	TIMER_BDCFG_DT_POSE	7U 
#define	TIMER_BDCFG_DT_MSK	BITS(TIMER_BDCFG_DT_POSS,TIMER_BDCFG_DT_POSE)

/****************** Bit definition for TIMER_DMAEN register ************************/

#define	TIMER_DMAEN_TRGDMA_POS	6U 
#define	TIMER_DMAEN_TRGDMA_MSK	BIT(TIMER_DMAEN_TRGDMA_POS)

#define	TIMER_DMAEN_COMDMA_POS	5U 
#define	TIMER_DMAEN_COMDMA_MSK	BIT(TIMER_DMAEN_COMDMA_POS)

#define	TIMER_DMAEN_CC4DMA_POS	4U 
#define	TIMER_DMAEN_CC4DMA_MSK	BIT(TIMER_DMAEN_CC4DMA_POS)

#define	TIMER_DMAEN_CC3DMA_POS	3U 
#define	TIMER_DMAEN_CC3DMA_MSK	BIT(TIMER_DMAEN_CC3DMA_POS)

#define	TIMER_DMAEN_CC2DMA_POS	2U 
#define	TIMER_DMAEN_CC2DMA_MSK	BIT(TIMER_DMAEN_CC2DMA_POS)

#define	TIMER_DMAEN_CC1DMA_POS	1U 
#define	TIMER_DMAEN_CC1DMA_MSK	BIT(TIMER_DMAEN_CC1DMA_POS)

#define	TIMER_DMAEN_UDMA_POS	0U 
#define	TIMER_DMAEN_UDMA_MSK	BIT(TIMER_DMAEN_UDMA_POS)

typedef struct
{
	__IO uint32_t CON1;
	__IO uint32_t CON2;
	__IO uint32_t SMCON;
	__O uint32_t IER;
	__O uint32_t IDR;
	__I uint32_t IVS;
	__I uint32_t RIF;
	__I uint32_t IFM;
	__O uint32_t ICR;
	__O uint32_t SGE;
	__IO uint32_t CHMR1;
	__IO uint32_t CHMR2;
	__IO uint32_t CCEP;
	__IO uint32_t COUNT;
	__IO uint32_t PRES;
	__IO uint32_t AR;
	__IO uint32_t REPAR;
	__IO uint32_t CCVAL1;
	__IO uint32_t CCVAL2;
	__IO uint32_t CCVAL3;
	__IO uint32_t CCVAL4;
	__IO uint32_t BDCFG;
	__IO uint32_t DMAEN;
} TIMER_TypeDef;





#endif
