/**
  **************************************************************************************
  * @file    REG_UART.h
  * @brief   UART Head File
  *
  * @version V0.01
  * @data    8/17/2020
  * @author  Eastsoft MCU Software Team
  * @note
  *
  * Copyright (C) 2018 Shanghai Eastsoft Microelectronics Co., Ltd. ALL rights reserved.
  *
  **************************************************************************************
  */

#ifndef __UART_H__
#define __UART_H__


/******************************************************************************/
/*                              设备特殊寄存器结构定义                        */
/******************************************************************************/

/*   允许匿名结构和匿名联合    */
 

/****************** Bit definition for UART_RXBUF register ************************/

#define	UART_RXBUF_RXBUF_POSS	0U 
#define	UART_RXBUF_RXBUF_POSE	8U 
#define	UART_RXBUF_RXBUF_MSK	BITS(UART_RXBUF_RXBUF_POSS,UART_RXBUF_RXBUF_POSE)

/****************** Bit definition for UART_TXBUF register ************************/

#define	UART_TXBUF_TXBUF_POSS	0U 
#define	UART_TXBUF_TXBUF_POSE	8U 
#define	UART_TXBUF_TXBUF_MSK	BITS(UART_TXBUF_TXBUF_POSS,UART_TXBUF_TXBUF_POSE)

/****************** Bit definition for UART_BRR register ************************/

#define	UART_BRR_BRR_POSS	0U 
#define	UART_BRR_BRR_POSE	15U 
#define	UART_BRR_BRR_MSK	BITS(UART_BRR_BRR_POSS,UART_BRR_BRR_POSE)

/****************** Bit definition for UART_LCON register ************************/

#define	UART_LCON_TXEN_POS	15U 
#define	UART_LCON_TXEN_MSK	BIT(UART_LCON_TXEN_POS)

#define	UART_LCON_RXEN_POS	14U 
#define	UART_LCON_RXEN_MSK	BIT(UART_LCON_RXEN_POS)

#define	UART_LCON_DBCEN_POS	13U 
#define	UART_LCON_DBCEN_MSK	BIT(UART_LCON_DBCEN_POS)

#define	UART_LCON_BREAK_POS	10U 
#define	UART_LCON_BREAK_MSK	BIT(UART_LCON_BREAK_POS)

#define	UART_LCON_TXINV_POS	8U 
#define	UART_LCON_TXINV_MSK	BIT(UART_LCON_TXINV_POS)

#define	UART_LCON_RXINV_POS	7U 
#define	UART_LCON_RXINV_MSK	BIT(UART_LCON_RXINV_POS)

#define	UART_LCON_DATAINV_POS	6U 
#define	UART_LCON_DATAINV_MSK	BIT(UART_LCON_DATAINV_POS)

#define	UART_LCON_MSB_POS	5U 
#define	UART_LCON_MSB_MSK	BIT(UART_LCON_MSB_POS)

#define	UART_LCON_PS_POS	4U 
#define	UART_LCON_PS_MSK	BIT(UART_LCON_PS_POS)

#define	UART_LCON_PE_POS	3U 
#define	UART_LCON_PE_MSK	BIT(UART_LCON_PE_POS)

#define	UART_LCON_STOP_POS	2U 
#define	UART_LCON_STOP_MSK	BIT(UART_LCON_STOP_POS)

#define	UART_LCON_DLS_POSS	0U 
#define	UART_LCON_DLS_POSE	1U 
#define	UART_LCON_DLS_MSK	BITS(UART_LCON_DLS_POSS,UART_LCON_DLS_POSE)

/****************** Bit definition for UART_MCON register ************************/

#define	UART_MCON_TXDMAEN_POS	15U 
#define	UART_MCON_TXDMAEN_MSK	BIT(UART_MCON_TXDMAEN_POS)

#define	UART_MCON_RXDMAEN_POS	14U 
#define	UART_MCON_RXDMAEN_MSK	BIT(UART_MCON_RXDMAEN_POS)

#define	UART_MCON_ABRREPT_POS	11U 
#define	UART_MCON_ABRREPT_MSK	BIT(UART_MCON_ABRREPT_POS)

#define	UART_MCON_ABRMOD_POSS	9U 
#define	UART_MCON_ABRMOD_POSE	10U 
#define	UART_MCON_ABRMOD_MSK	BITS(UART_MCON_ABRMOD_POSS,UART_MCON_ABRMOD_POSE)

#define	UART_MCON_ABREN_POS	8U 
#define	UART_MCON_ABREN_MSK	BIT(UART_MCON_ABREN_POS)

#define	UART_MCON_BKREQ_POS	5U 
#define	UART_MCON_BKREQ_MSK	BIT(UART_MCON_BKREQ_POS)

#define	UART_MCON_HDEN_POS	4U 
#define	UART_MCON_HDEN_MSK	BIT(UART_MCON_HDEN_POS)

#define	UART_MCON_IREN_POS	3U 
#define	UART_MCON_IREN_MSK	BIT(UART_MCON_IREN_POS)

#define	UART_MCON_AFCEN_POS	2U 
#define	UART_MCON_AFCEN_MSK	BIT(UART_MCON_AFCEN_POS)

#define	UART_MCON_RTSSET_POS	1U 
#define	UART_MCON_RTSSET_MSK	BIT(UART_MCON_RTSSET_POS)

#define	UART_MCON_LPBKEN_POS	0U 
#define	UART_MCON_LPBKEN_MSK	BIT(UART_MCON_LPBKEN_POS)

/****************** Bit definition for UART_RS485 register ************************/

#define	UART_RS485_DLY_POSS	16U 
#define	UART_RS485_DLY_POSE	23U 
#define	UART_RS485_DLY_MSK	BITS(UART_RS485_DLY_POSS,UART_RS485_DLY_POSE)

#define	UART_RS485_ADDR_POSS	8U 
#define	UART_RS485_ADDR_POSE	15U 
#define	UART_RS485_ADDR_MSK	BITS(UART_RS485_ADDR_POSS,UART_RS485_ADDR_POSE)

#define	UART_RS485_AADINV_POS	3U 
#define	UART_RS485_AADINV_MSK	BIT(UART_RS485_AADINV_POS)

#define	UART_RS485_AADACEN_POS	2U 
#define	UART_RS485_AADACEN_MSK	BIT(UART_RS485_AADACEN_POS)

#define	UART_RS485_AADNEN_POS	1U 
#define	UART_RS485_AADNEN_MSK	BIT(UART_RS485_AADNEN_POS)

#define	UART_RS485_AADEN_POS	0U 
#define	UART_RS485_AADEN_MSK	BIT(UART_RS485_AADEN_POS)

/****************** Bit definition for UART_SCARD register ************************/

#define	UART_SCARD_BLEN_POSS	24U 
#define	UART_SCARD_BLEN_POSE	31U 
#define	UART_SCARD_BLEN_MSK	BITS(UART_SCARD_BLEN_POSS,UART_SCARD_BLEN_POSE)

#define	UART_SCARD_GT_POSS	16U 
#define	UART_SCARD_GT_POSE	23U 
#define	UART_SCARD_GT_MSK	BITS(UART_SCARD_GT_POSS,UART_SCARD_GT_POSE)

#define	UART_SCARD_PSC_POSS	8U 
#define	UART_SCARD_PSC_POSE	15U 
#define	UART_SCARD_PSC_MSK	BITS(UART_SCARD_PSC_POSS,UART_SCARD_PSC_POSE)

#define	UART_SCARD_SCCNT_POSS	3U 
#define	UART_SCARD_SCCNT_POSE	5U 
#define	UART_SCARD_SCCNT_MSK	BITS(UART_SCARD_SCCNT_POSS,UART_SCARD_SCCNT_POSE)

#define	UART_SCARD_SCLKEN_POS	2U 
#define	UART_SCARD_SCLKEN_MSK	BIT(UART_SCARD_SCLKEN_POS)

#define	UART_SCARD_SCNACK_POS	1U 
#define	UART_SCARD_SCNACK_MSK	BIT(UART_SCARD_SCNACK_POS)

#define	UART_SCARD_SCEN_POS	0U 
#define	UART_SCARD_SCEN_MSK	BIT(UART_SCARD_SCEN_POS)

/****************** Bit definition for UART_LIN register ************************/

#define	UART_LIN_LINBKREQ_POS	2U 
#define	UART_LIN_LINBKREQ_MSK	BIT(UART_LIN_LINBKREQ_POS)

#define	UART_LIN_LINBDL_POS	1U 
#define	UART_LIN_LINBDL_MSK	BIT(UART_LIN_LINBDL_POS)

#define	UART_LIN_LINEN_POS	0U 
#define	UART_LIN_LINEN_MSK	BIT(UART_LIN_LINEN_POS)

/****************** Bit definition for UART_RTOR register ************************/

#define	UART_RTOR_RTOEN_POS	24U 
#define	UART_RTOR_RTOEN_MSK	BIT(UART_RTOR_RTOEN_POS)

#define	UART_RTOR_RTO_POSS	0U 
#define	UART_RTOR_RTO_POSE	23U 
#define	UART_RTOR_RTO_MSK	BITS(UART_RTOR_RTO_POSS,UART_RTOR_RTO_POSE)

/****************** Bit definition for UART_FCON register ************************/

#define	UART_FCON_TXFL_POSS	11U 
#define	UART_FCON_TXFL_POSE	15U 
#define	UART_FCON_TXFL_MSK	BITS(UART_FCON_TXFL_POSS,UART_FCON_TXFL_POSE)

#define	UART_FCON_TXTH_POSS	9U 
#define	UART_FCON_TXTH_POSE	10U 
#define	UART_FCON_TXTH_MSK	BITS(UART_FCON_TXTH_POSS,UART_FCON_TXTH_POSE)

#define	UART_FCON_TFRST_POS	8U 
#define	UART_FCON_TFRST_MSK	BIT(UART_FCON_TFRST_POS)

#define	UART_FCON_RXFL_POSS	3U 
#define	UART_FCON_RXFL_POSE	7U 
#define	UART_FCON_RXFL_MSK	BITS(UART_FCON_RXFL_POSS,UART_FCON_RXFL_POSE)

#define	UART_FCON_RXTH_POSS	1U 
#define	UART_FCON_RXTH_POSE	2U 
#define	UART_FCON_RXTH_MSK	BITS(UART_FCON_RXTH_POSS,UART_FCON_RXTH_POSE)

#define	UART_FCON_RFRST_POS	0U 
#define	UART_FCON_RFRST_MSK	BIT(UART_FCON_RFRST_POS)

/****************** Bit definition for UART_STAT register ************************/

#define	UART_STAT_TFOERR_POS	18U 
#define	UART_STAT_TFOERR_MSK	BIT(UART_STAT_TFOERR_POS)

#define	UART_STAT_TFFULL_POS	17U 
#define	UART_STAT_TFFULL_MSK	BIT(UART_STAT_TFFULL_POS)

#define	UART_STAT_TFEMPTY_POS	16U 
#define	UART_STAT_TFEMPTY_MSK	BIT(UART_STAT_TFEMPTY_POS)

#define	UART_STAT_TFTH_POS	15U 
#define	UART_STAT_TFTH_MSK	BIT(UART_STAT_TFTH_POS)

#define	UART_STAT_TSBUSY_POS	14U 
#define	UART_STAT_TSBUSY_MSK	BIT(UART_STAT_TSBUSY_POS)

#define	UART_STAT_RFUERR_POS	13U 
#define	UART_STAT_RFUERR_MSK	BIT(UART_STAT_RFUERR_POS)

#define	UART_STAT_RFOERR_POS	12U 
#define	UART_STAT_RFOERR_MSK	BIT(UART_STAT_RFOERR_POS)

#define	UART_STAT_RFFULL_POS	11U 
#define	UART_STAT_RFFULL_MSK	BIT(UART_STAT_RFFULL_POS)

#define	UART_STAT_RFEMPTY_POS	10U 
#define	UART_STAT_RFEMPTY_MSK	BIT(UART_STAT_RFEMPTY_POS)

#define	UART_STAT_RFTH_POS	9U 
#define	UART_STAT_RFTH_MSK	BIT(UART_STAT_RFTH_POS)

#define	UART_STAT_RSBUSY_POS	8U 
#define	UART_STAT_RSBUSY_MSK	BIT(UART_STAT_RSBUSY_POS)

#define	UART_STAT_CTSSTA_POS	3U 
#define	UART_STAT_CTSSTA_MSK	BIT(UART_STAT_CTSSTA_POS)

#define	UART_STAT_BKERR_POS	2U 
#define	UART_STAT_BKERR_MSK	BIT(UART_STAT_BKERR_POS)

#define	UART_STAT_FERR_POS	1U 
#define	UART_STAT_FERR_MSK	BIT(UART_STAT_FERR_POS)

#define	UART_STAT_PERR_POS	0U 
#define	UART_STAT_PERR_MSK	BIT(UART_STAT_PERR_POS)

/****************** Bit definition for UART_IER register ************************/

#define	UART_IER_TFOVER_POS	18U 
#define	UART_IER_TFOVER_MSK	BIT(UART_IER_TFOVER_POS)

#define	UART_IER_TFEMPTY_POS	16U 
#define	UART_IER_TFEMPTY_MSK	BIT(UART_IER_TFEMPTY_POS)

#define	UART_IER_TFTH_POS	15U 
#define	UART_IER_TFTH_MSK	BIT(UART_IER_TFTH_POS)

#define	UART_IER_TBC_POS	14U 
#define	UART_IER_TBC_MSK	BIT(UART_IER_TBC_POS)

#define	UART_IER_RFUERR_POS	13U 
#define	UART_IER_RFUERR_MSK	BIT(UART_IER_RFUERR_POS)

#define	UART_IER_RFOERR_POS	12U 
#define	UART_IER_RFOERR_MSK	BIT(UART_IER_RFOERR_POS)

#define	UART_IER_RFFULL_POS	11U 
#define	UART_IER_RFFULL_MSK	BIT(UART_IER_RFFULL_POS)

#define	UART_IER_RFTH_POS	9U 
#define	UART_IER_RFTH_MSK	BIT(UART_IER_RFTH_POS)

#define	UART_IER_NOISE_POS	8U 
#define	UART_IER_NOISE_MSK	BIT(UART_IER_NOISE_POS)

#define	UART_IER_EOB_POS	7U 
#define	UART_IER_EOB_MSK	BIT(UART_IER_EOB_POS)

#define	UART_IER_LINBK_POS	6U 
#define	UART_IER_LINBK_MSK	BIT(UART_IER_LINBK_POS)

#define	UART_IER_ADDRM_POS	5U 
#define	UART_IER_ADDRM_MSK	BIT(UART_IER_ADDRM_POS)

#define	UART_IER_RXTO_POS	4U 
#define	UART_IER_RXTO_MSK	BIT(UART_IER_RXTO_POS)

#define	UART_IER_DCTS_POS	3U 
#define	UART_IER_DCTS_MSK	BIT(UART_IER_DCTS_POS)

#define	UART_IER_ABTO_POS	2U 
#define	UART_IER_ABTO_MSK	BIT(UART_IER_ABTO_POS)

#define	UART_IER_ABEND_POS	1U 
#define	UART_IER_ABEND_MSK	BIT(UART_IER_ABEND_POS)

#define	UART_IER_RXBERR_POS	0U 
#define	UART_IER_RXBERR_MSK	BIT(UART_IER_RXBERR_POS)

/****************** Bit definition for UART_IDR register ************************/

#define	UART_IDR_TFOVER_POS	18U 
#define	UART_IDR_TFOVER_MSK	BIT(UART_IDR_TFOVER_POS)

#define	UART_IDR_TFEMPTY_POS	16U 
#define	UART_IDR_TFEMPTY_MSK	BIT(UART_IDR_TFEMPTY_POS)

#define	UART_IDR_TFTH_POS	15U 
#define	UART_IDR_TFTH_MSK	BIT(UART_IDR_TFTH_POS)

#define	UART_IDR_TBC_POS	14U 
#define	UART_IDR_TBC_MSK	BIT(UART_IDR_TBC_POS)

#define	UART_IDR_RFUERR_POS	13U 
#define	UART_IDR_RFUERR_MSK	BIT(UART_IDR_RFUERR_POS)

#define	UART_IDR_RFOERR_POS	12U 
#define	UART_IDR_RFOERR_MSK	BIT(UART_IDR_RFOERR_POS)

#define	UART_IDR_RFFULL_POS	11U 
#define	UART_IDR_RFFULL_MSK	BIT(UART_IDR_RFFULL_POS)

#define	UART_IDR_RFTH_POS	9U 
#define	UART_IDR_RFTH_MSK	BIT(UART_IDR_RFTH_POS)

#define	UART_IDR_NOISE_POS	8U 
#define	UART_IDR_NOISE_MSK	BIT(UART_IDR_NOISE_POS)

#define	UART_IDR_EOB_POS	7U 
#define	UART_IDR_EOB_MSK	BIT(UART_IDR_EOB_POS)

#define	UART_IDR_LINBK_POS	6U 
#define	UART_IDR_LINBK_MSK	BIT(UART_IDR_LINBK_POS)

#define	UART_IDR_ADDRM_POS	5U 
#define	UART_IDR_ADDRM_MSK	BIT(UART_IDR_ADDRM_POS)

#define	UART_IDR_RXTO_POS	4U 
#define	UART_IDR_RXTO_MSK	BIT(UART_IDR_RXTO_POS)

#define	UART_IDR_DCTS_POS	3U 
#define	UART_IDR_DCTS_MSK	BIT(UART_IDR_DCTS_POS)

#define	UART_IDR_ABTO_POS	2U 
#define	UART_IDR_ABTO_MSK	BIT(UART_IDR_ABTO_POS)

#define	UART_IDR_ABEND_POS	1U 
#define	UART_IDR_ABEND_MSK	BIT(UART_IDR_ABEND_POS)

#define	UART_IDR_RXBERR_POS	0U 
#define	UART_IDR_RXBERR_MSK	BIT(UART_IDR_RXBERR_POS)

/****************** Bit definition for UART_IVS register ************************/

#define	UART_IVS_TFOVER_POS	18U 
#define	UART_IVS_TFOVER_MSK	BIT(UART_IVS_TFOVER_POS)

#define	UART_IVS_TFEMPTY_POS	16U 
#define	UART_IVS_TFEMPTY_MSK	BIT(UART_IVS_TFEMPTY_POS)

#define	UART_IVS_TFTH_POS	15U 
#define	UART_IVS_TFTH_MSK	BIT(UART_IVS_TFTH_POS)

#define	UART_IVS_TBC_POS	14U 
#define	UART_IVS_TBC_MSK	BIT(UART_IVS_TBC_POS)

#define	UART_IVS_RFUERR_POS	13U 
#define	UART_IVS_RFUERR_MSK	BIT(UART_IVS_RFUERR_POS)

#define	UART_IVS_RFOERR_POS	12U 
#define	UART_IVS_RFOERR_MSK	BIT(UART_IVS_RFOERR_POS)

#define	UART_IVS_RFFULL_POS	11U 
#define	UART_IVS_RFFULL_MSK	BIT(UART_IVS_RFFULL_POS)

#define	UART_IVS_RFTH_POS	9U 
#define	UART_IVS_RFTH_MSK	BIT(UART_IVS_RFTH_POS)

#define	UART_IVS_NOISE_POS	8U 
#define	UART_IVS_NOISE_MSK	BIT(UART_IVS_NOISE_POS)

#define	UART_IVS_EOB_POS	7U 
#define	UART_IVS_EOB_MSK	BIT(UART_IVS_EOB_POS)

#define	UART_IVS_LINBK_POS	6U 
#define	UART_IVS_LINBK_MSK	BIT(UART_IVS_LINBK_POS)

#define	UART_IVS_ADDRM_POS	5U 
#define	UART_IVS_ADDRM_MSK	BIT(UART_IVS_ADDRM_POS)

#define	UART_IVS_RXTO_POS	4U 
#define	UART_IVS_RXTO_MSK	BIT(UART_IVS_RXTO_POS)

#define	UART_IVS_DCTS_POS	3U 
#define	UART_IVS_DCTS_MSK	BIT(UART_IVS_DCTS_POS)

#define	UART_IVS_ABTO_POS	2U 
#define	UART_IVS_ABTO_MSK	BIT(UART_IVS_ABTO_POS)

#define	UART_IVS_ABEND_POS	1U 
#define	UART_IVS_ABEND_MSK	BIT(UART_IVS_ABEND_POS)

#define	UART_IVS_RXBERR_POS	0U 
#define	UART_IVS_RXBERR_MSK	BIT(UART_IVS_RXBERR_POS)

/****************** Bit definition for UART_RIF register ************************/

#define	UART_RIF_TFOVER_POS	18U 
#define	UART_RIF_TFOVER_MSK	BIT(UART_RIF_TFOVER_POS)

#define	UART_RIF_TFEMPTY_POS	16U 
#define	UART_RIF_TFEMPTY_MSK	BIT(UART_RIF_TFEMPTY_POS)

#define	UART_RIF_TFTH_POS	15U 
#define	UART_RIF_TFTH_MSK	BIT(UART_RIF_TFTH_POS)

#define	UART_RIF_TBC_POS	14U 
#define	UART_RIF_TBC_MSK	BIT(UART_RIF_TBC_POS)

#define	UART_RIF_RFUERR_POS	13U 
#define	UART_RIF_RFUERR_MSK	BIT(UART_RIF_RFUERR_POS)

#define	UART_RIF_RFOERR_POS	12U 
#define	UART_RIF_RFOERR_MSK	BIT(UART_RIF_RFOERR_POS)

#define	UART_RIF_RFFULL_POS	11U 
#define	UART_RIF_RFFULL_MSK	BIT(UART_RIF_RFFULL_POS)

#define	UART_RIF_RFTH_POS	9U 
#define	UART_RIF_RFTH_MSK	BIT(UART_RIF_RFTH_POS)

#define	UART_RIF_NOISE_POS	8U 
#define	UART_RIF_NOISE_MSK	BIT(UART_RIF_NOISE_POS)

#define	UART_RIF_EOB_POS	7U 
#define	UART_RIF_EOB_MSK	BIT(UART_RIF_EOB_POS)

#define	UART_RIF_LINBK_POS	6U 
#define	UART_RIF_LINBK_MSK	BIT(UART_RIF_LINBK_POS)

#define	UART_RIF_ADDRM_POS	5U 
#define	UART_RIF_ADDRM_MSK	BIT(UART_RIF_ADDRM_POS)

#define	UART_RIF_RXTO_POS	4U 
#define	UART_RIF_RXTO_MSK	BIT(UART_RIF_RXTO_POS)

#define	UART_RIF_DCTS_POS	3U 
#define	UART_RIF_DCTS_MSK	BIT(UART_RIF_DCTS_POS)

#define	UART_RIF_ABTO_POS	2U 
#define	UART_RIF_ABTO_MSK	BIT(UART_RIF_ABTO_POS)

#define	UART_RIF_ABEND_POS	1U 
#define	UART_RIF_ABEND_MSK	BIT(UART_RIF_ABEND_POS)

#define	UART_RIF_RXBERR_POS	0U 
#define	UART_RIF_RXBERR_MSK	BIT(UART_RIF_RXBERR_POS)

/****************** Bit definition for UART_IFM register ************************/

#define	UART_IFM_TFOVER_POS	18U 
#define	UART_IFM_TFOVER_MSK	BIT(UART_IFM_TFOVER_POS)

#define	UART_IFM_TFEMPTY_POS	16U 
#define	UART_IFM_TFEMPTY_MSK	BIT(UART_IFM_TFEMPTY_POS)

#define	UART_IFM_TFTH_POS	15U 
#define	UART_IFM_TFTH_MSK	BIT(UART_IFM_TFTH_POS)

#define	UART_IFM_TBC_POS	14U 
#define	UART_IFM_TBC_MSK	BIT(UART_IFM_TBC_POS)

#define	UART_IFM_RFUERR_POS	13U 
#define	UART_IFM_RFUERR_MSK	BIT(UART_IFM_RFUERR_POS)

#define	UART_IFM_RFOERR_POS	12U 
#define	UART_IFM_RFOERR_MSK	BIT(UART_IFM_RFOERR_POS)

#define	UART_IFM_RFFULL_POS	11U 
#define	UART_IFM_RFFULL_MSK	BIT(UART_IFM_RFFULL_POS)

#define	UART_IFM_RFTH_POS	9U 
#define	UART_IFM_RFTH_MSK	BIT(UART_IFM_RFTH_POS)

#define	UART_IFM_NOISE_POS	8U 
#define	UART_IFM_NOISE_MSK	BIT(UART_IFM_NOISE_POS)

#define	UART_IFM_EOB_POS	7U 
#define	UART_IFM_EOB_MSK	BIT(UART_IFM_EOB_POS)

#define	UART_IFM_LINBK_POS	6U 
#define	UART_IFM_LINBK_MSK	BIT(UART_IFM_LINBK_POS)

#define	UART_IFM_ADDRM_POS	5U 
#define	UART_IFM_ADDRM_MSK	BIT(UART_IFM_ADDRM_POS)

#define	UART_IFM_RXTO_POS	4U 
#define	UART_IFM_RXTO_MSK	BIT(UART_IFM_RXTO_POS)

#define	UART_IFM_DCTS_POS	3U 
#define	UART_IFM_DCTS_MSK	BIT(UART_IFM_DCTS_POS)

#define	UART_IFM_ABTO_POS	2U 
#define	UART_IFM_ABTO_MSK	BIT(UART_IFM_ABTO_POS)

#define	UART_IFM_ABEND_POS	1U 
#define	UART_IFM_ABEND_MSK	BIT(UART_IFM_ABEND_POS)

#define	UART_IFM_RXBERR_POS	0U 
#define	UART_IFM_RXBERR_MSK	BIT(UART_IFM_RXBERR_POS)

/****************** Bit definition for UART_ICR register ************************/

#define	UART_ICR_TFOVER_POS	18U 
#define	UART_ICR_TFOVER_MSK	BIT(UART_ICR_TFOVER_POS)

#define	UART_ICR_TFEMPTY_POS	16U 
#define	UART_ICR_TFEMPTY_MSK	BIT(UART_ICR_TFEMPTY_POS)

#define	UART_ICR_TFTH_POS	15U 
#define	UART_ICR_TFTH_MSK	BIT(UART_ICR_TFTH_POS)

#define	UART_ICR_TBC_POS	14U 
#define	UART_ICR_TBC_MSK	BIT(UART_ICR_TBC_POS)

#define	UART_ICR_RFUERR_POS	13U 
#define	UART_ICR_RFUERR_MSK	BIT(UART_ICR_RFUERR_POS)

#define	UART_ICR_RFOERR_POS	12U 
#define	UART_ICR_RFOERR_MSK	BIT(UART_ICR_RFOERR_POS)

#define	UART_ICR_RFFULL_POS	11U 
#define	UART_ICR_RFFULL_MSK	BIT(UART_ICR_RFFULL_POS)

#define	UART_ICR_RFTH_POS	9U 
#define	UART_ICR_RFTH_MSK	BIT(UART_ICR_RFTH_POS)

#define	UART_ICR_NOISE_POS	8U 
#define	UART_ICR_NOISE_MSK	BIT(UART_ICR_NOISE_POS)

#define	UART_ICR_EOB_POS	7U 
#define	UART_ICR_EOB_MSK	BIT(UART_ICR_EOB_POS)

#define	UART_ICR_LINBK_POS	6U 
#define	UART_ICR_LINBK_MSK	BIT(UART_ICR_LINBK_POS)

#define	UART_ICR_ADDRM_POS	5U 
#define	UART_ICR_ADDRM_MSK	BIT(UART_ICR_ADDRM_POS)

#define	UART_ICR_RXTO_POS	4U 
#define	UART_ICR_RXTO_MSK	BIT(UART_ICR_RXTO_POS)

#define	UART_ICR_DCTS_POS	3U 
#define	UART_ICR_DCTS_MSK	BIT(UART_ICR_DCTS_POS)

#define	UART_ICR_ABTO_POS	2U 
#define	UART_ICR_ABTO_MSK	BIT(UART_ICR_ABTO_POS)

#define	UART_ICR_ABEND_POS	1U 
#define	UART_ICR_ABEND_MSK	BIT(UART_ICR_ABEND_POS)

#define	UART_ICR_RXBERR_POS	0U 
#define	UART_ICR_RXBERR_MSK	BIT(UART_ICR_RXBERR_POS)

typedef struct
{
	__I uint32_t RXBUF;
	__IO uint32_t TXBUF;
	__IO uint32_t BRR;
	__IO uint32_t LCON;
	__IO uint32_t MCON;
	__IO uint32_t RS485;
	__IO uint32_t SCARD;
	__IO uint32_t LIN;
	__IO uint32_t RTOR;
	__O uint32_t FCON;
	__I uint32_t STAT;
	__O uint32_t IER;
	__O uint32_t IDR;
	__I uint32_t IVS;
	__I uint32_t RIF;
	__I uint32_t IFM;
	__O uint32_t ICR;
} UART_TypeDef;





#endif
