/*******************************************************************
* *file       : ES32F027x.h
* *description: ES32F027x Device Head File
* *author     : Eastsoft AE Team
* *version    : V0.01
* *data       : 11/12/2018
*
* *Copyright (C) 2018 Shanghai Eastsoft Microelectronics Co., Ltd.
*******************************************************************/

/** @addtogroup CMSIS
  * @{
  */
 
/** @addtogroup ES32F027x
  * @{
  */
  
#ifndef __ES32F027x_H__
#define __ES32F027x_H__

#ifdef __cplusplus
extern "C"{
#endif

/** 
  * @brief defines 'read only' 、'write only'、 'read / write' permissions.
  */
#define __I volatile const /* defines 'read only' permissions */
#define __O volatile /* defines 'write only' permissions */
#define __IO volatile /* defines 'read / write' permissions */
  
/** @addtogroup Configuration_section_for_CMSIS
  * @{
  */
  
/** 
  * @brief configuration of the cortex-M0 processor and core peripherals.
  */  
#define __NVIC_PRIO_BITS 2 /* ES32F027x uses 2 Bits for the Priority Levels */

/**
  * @}Configuration_section_for_CMSIS
  */ 

/** @addtogroup Peripherals_interrupt_number_definition
  * @{
  */

/**
 * @brief ES32F027x Interrupt Number Definition, according to the selected device 
 *        in @ref Library_configuration_section 
 */
TypeDef enum IRQn{  
  
  /***************        Cortex-M0 Processor Exceptions Index        **************************/
  Reset_IRQn        = -15,
  NMI_IRQn          = -14,
  HardFault_IRQn    = -13,
  SVCall_IRQn       = -5,
  DebugMonitor_IRQn = -4,
  PendSV_IRQn       = -2,
  SysTick_IRQn      = -1,
  
  /****************        ES32F027x_SUB specific Exceptions Numbers        **************************/
  WWDG_IRQn               = 0,
  PVD_IRQn                = 1,
  RTC_IRQn                = 2,
  LOWPWR_WKUP_IRQn        = 3,
  RESERVED0_IRQn          = 4,
  EXTI0_1_IRQn            = 5,
  EXTI2_3_IRQn            = 6,
  EXTI4_15_IRQn           = 7,
	RESERVED1_IRQn          = 8,
  DMA1CH1_IRQn            = 9,
  DMA1CH2_3_IRQn          = 10,
  DMA1CH4_7_IRQn          = 11,
  ADC_CMP_IRQn            = 12,
  AD16C4T1_IRQn           = 13,
  BS16T1_IRQn             = 14,
  GP32C4T1_IRQn           = 15,
  GP16C4T1_IRQn           = 16,
  GP16C4T2_IRQn           = 17,
  GP16C4T3_IRQn           = 18,
  GP16C2T1_IRQn           = 19,
  GP16C2T2_IRQn           = 20,
  GP16C2T3_IRQn           = 21,
  GP16C2T4_IRQn           = 22,
  I2C1_IRQn               = 23,
  I2C2_IRQn               = 24,
  SPI1_IRQn               = 25,
  SPI2_IRQn               = 26,
  UART1_IRQn              = 27,
  UART2_IRQn              = 28,
  UART3_AES_IRQn          = 29,
  SUART1_SUART2_IRQn      = 30,
  USB_IRQn                = 31,
} IRQn_Type;

/**
  * @}Peripherals_interrupt_number_definition
  */ 

/* Includes-------------------------------------------------------------------------------*/
#include "core_cm0.h"
#include <stdint.h>


/** 
  * @brief these files declare Peripheral register bit_definition.
  */

#include "./ES32F027x/reg_adc.h"
#include "./ES32F027x/reg_aes.h"
#include "./ES32F027x/reg_cmp.h"
#include "./ES32F027x/reg_crc.h"
#include "./ES32F027x/reg_dac.h"
#include "./ES32F027x/reg_dma.h"
#include "./ES32F027x/reg_exti.h"
#include "./ES32F027x/reg_fc.h"
#include "./ES32F027x/reg_gpio.h"
#include "./ES32F027x/reg_hdiv.h"
#include "./ES32F027x/reg_tim.h"
#include "./ES32F027x/reg_i2c.h"
#include "./ES32F027x/reg_iwdg.h"
#include "./ES32F027x/reg_nvic.h"
#include "./ES32F027x/reg_rcu.h"
#include "./ES32F027x/reg_rtc.h"
#include "./ES32F027x/reg_spi.h"
#include "./ES32F027x/reg_syscfg.h"
#include "./ES32F027x/reg_sys.h"
#include "./ES32F027x/reg_uart.h"
#include "./ES32F027x/reg_wwdg.h"

/******************************************************************************/
/*                              Peripheral register                           */
/******************************************************************************/

/*   allow anonymous structures and anonymous enumeration    */
#pragma anon_unions

/******************************************************************************/
/*                            Peripheral memory map                           */
/******************************************************************************/
 
/*********************      Base addresses        *************************/
#define SRAM_BASE  (0x20000000UL)
#define APB1_BASE  (0x40000000UL)
#define APB2_BASE  (0x40010000UL)
#define AHB1_BASE  (0x40020000UL)
#define AHB2_BASE  (0x48000000UL)
#define SYS_BASE   (0xE0000000UL)

/*********************      APB1 peripherals        *************************/
#define GP32C4T1_BASE (APB1_BASE + 0X0000)
#define GP16C4T1_BASE (APB1_BASE + 0X0400)
#define GP16C4T2_BASE (APB1_BASE + 0X0800)
#define GP16C4T3_BASE (APB1_BASE + 0X0C00)
#define BS16T1_BASE (APB1_BASE + 0X1000)
#define WWDG_BASE (APB1_BASE + 0X2C00)
#define IWDG_BASE (APB1_BASE + 0X3000)
#define SPI2_I2S2_BASE (APB1_BASE + 0X3800)
#define UART2_BASE (APB1_BASE + 0X4400)
#define UART3_BASE (APB1_BASE + 0X4800)
#define SUART1_BASE (APB1_BASE + 0X4C00)
#define SUART2_BASE (APB1_BASE + 0X5000)
#define I2C1_BASE (APB1_BASE + 0X5400)
#define I2C2_BASE (APB1_BASE + 0X5800)
#define DAC_BASE (APB1_BASE + 0X5C00)

/*********************      APB2 peripherals        *************************/
#define EXIT_BASE (APB2_BASE + 0X0400)
#define ADC_BASE (APB2_BASE + 0X2400)
#define AD16C4T1_BASE (APB2_BASE + 0X2C00)
#define SPI1_I2S1_BASE (APB2_BASE + 0X3000)
#define UART1_BASE (APB2_BASE + 0X3800)
#define GP16C2T1_BASE (APB2_BASE + 0X4000)
#define GP16C2T2_BASE (APB2_BASE + 0X4400)
#define GP16C2T3_BASE (APB2_BASE + 0X4800)
#define GP16C2T4_BASE (APB2_BASE + 0X4C00)
#define CMP_BASE (APB2_BASE + 0X5C00)

/*********************      AHB1 peripherals        *************************/
#define DMA1_BASE (AHB1_BASE + 0X0000)
#define RCU_BASE (AHB1_BASE + 0X1000)
#define SYSCFG_BASE (AHB1_BASE + 0X1400)
#define RTC_BASE (AHB1_BASE + 0X1800)
#define FC_BASE (AHB1_BASE + 0X2000)
#define CRC_BASE (AHB1_BASE + 0X3000)
#define AES_BASE (AHB1_BASE + 0X3400)
#define USB_BASE (AHB1_BASE + 0X3800)
#define HDIV_BASE (AHB1_BASE + 0X3C00)


/*********************      AHB2 peripherals        *************************/
#define GPIOA_BASE (AHB2_BASE + 0X0000)
#define GPIOB_BASE (AHB2_BASE + 0X0400)
#define GPIOC_BASE (AHB2_BASE + 0X0800)
#define GPIOD_BASE (AHB2_BASE + 0X0C00)



/*********************      Peripheral declaration        *************************/
#define GP32C4T1 ((TIM_TypeDef *)GP32C4T1_BASE)
#define GP16C4T1 ((TIM_TypeDef *)GP16C4T1_BASE)
#define GP16C4T2 ((TIM_TypeDef *)GP16C4T2_BASE)
#define GP16C4T3 ((TIM_TypeDef *)GP16C4T3_BASE)
#define BS16T1 ((BS16T_TypeDef *)BS16T1_BASE)
#define WWDG ((WWDG_TypeDef *)WWDG_BASE)
#define IWDG ((IWDG_TypeDef *)IWDG_BASE)
#define SPI2 ((SPI_TypeDef *)SPI2_I2S2_BASE)
#define I2S2 ((SPI_TypeDef *)SPI2_I2S2_BASE)
#define UART2 ((UART_TypeDef *)UART2_BASE)
#define UART3 ((UART_TypeDef *)UART3_BASE)
#define SUART1 ((UART_TypeDef *)SUART1_BASE )
#define SUART2 ((UART_TypeDef *)SUART2_BASE )
#define I2C1 ((I2C_TypeDef *)I2C1_BASE )
#define I2C2 ((I2C_TypeDef *)I2C2_BASE )
#define DAC ((DAC_TypeDef *)DAC_BASE )
#define EXIT ((EXIT_TypeDef *)EXIT_BASE )
#define ADC ((ADC_TypeDef *)ADC_BASE )
#define AD16C4T1 ((TIM_TypeDef *)AD16C4T1_BASE )
#define SPI1 ((SPI_TypeDef *)SPI1_I2S1_BASE )
#define I2S1 ((SPI_TypeDef *)SPI1_I2S1_BASE )
#define UART1 ((UART_TypeDef *)UART1_BASE )
#define GP16C2T1 ((TIM_TypeDef *)GP16C2T1_BASE )
#define GP16C2T2 ((TIM_TypeDef *)GP16C2T2_BASE )
#define GP16C2T3 ((TIM_TypeDef *)GP16C2T3_BASE )
#define GP16C2T4 ((TIM_TypeDef *)GP16C2T4_BASE )
#define CMP ((CMP_TypeDef *)CMP_BASE )
#define DMA1 ((DMA_TypeDef *)DMA1_BASE )
#define RCU ((RCU_TypeDef *)RCU_BASE )
#define SYSCFG ((SYSCFG_TypeDef *)SYSCFG_BASE )
#define RTC ((RTC_TypeDef *)RTC_BASE )
#define FC ((FC_TypeDef *)FC_BASE )
#define CRC ((CRC_TypeDef *)CRC_BASE )
#define AES ((AES_TypeDef *)AES_BASE )
#define USB ((USB_TypeDef *)USB_BASE )
#define HDIV ((HDIV_TypeDef *)HDIV_BASE )
#define GPIOA ((GPIO_TypeDef *)GPIOA_BASE )
#define GPIOB ((GPIO_TypeDef *)GPIOB_BASE )
#define GPIOC ((GPIO_TypeDef *)GPIOC_BASE )
#define GPIOD ((GPIO_TypeDef *)GPIOD_BASE )
#define SYSTICK ((SYS_TypeDef *)SYS_BASE )



/******************************************************************************/
/*                                types                                       */
/******************************************************************************/  
/** @addtogroup Public_types
  * @{
  */
  
TypeDef enum 
{  
  DISABLE = 0,
  ENABLE = !DISABLE
} TYPE_FUNCEN,FuncState,TYPE_PINTIE,TYPE_PINTMASK;

TypeDef enum 
{
  RESET = 0, 
  SET = !RESET
} FlagStatus, ITStatus, PinStatus;

TypeDef enum 
{
  ERROR = 0, 
  SUCCESS = !ERROR
} ErrorStatus;

/** 
  * @}Public_types
  */


/******************************************************************************/
/*                                     Bits_macros                            */
/******************************************************************************/
/** @addtogroup Public_macro
  * @{
  */  
#ifdef USE_ASSERT
#define assert_param(x)   \
do                        \
{                         \
  if (!(x))               \
  {                       \
    __disable_irq();      \
    while (1)             \
    ;                     \
  }                       \
} while (0)
#else
#define assert_param(x)
#endif

#define BIT(x)                   ((uint32_t)((uint32_t)0x01U<<(x)))

#define BITS(start, end)         ((0xFFFFFFFFUL << (start)) &\
                                  (0xFFFFFFFFUL >> (31U - (uint32_t)(end)))) 

#define SET_BIT(REG, SETMASK)     ((REG) |= (SETMASK))

#define CLEAR_BIT(REG, SETMASK)   ((REG) &= ~(SETMASK))

#define READ_BIT(REG, SETMASK)    ((REG) & (SETMASK))

#define CLEAR_REG(REG)            ((REG) = (0x0))

#define WRITE_REG(REG, VAL)       ((REG) = (VAL))

#define READ_REG(REG)             ((REG))

#define MODIFY_REG(REG, CLEARMASK, SETMASK)  WRITE_REG((REG), (((READ_REG(REG)) & (~(CLEARMASK))) | (SETMASK)))

#define POSITION_VAL(VAL)         (__CLZ(__RBIT(VAL)))

/**
  * @}Public_macro
  */

#ifdef __cplusplus
}
#endif  
      
#endif

/** 
  * @}ES32F027x
  */
  
/** 
  * @}CMSIS
  */
/******************* (C) COPYRIGHT Eastsoft Microelectronics END OF M601_SUB.H****/
