;*******************************************************************************
; file       : startup_m601.s
; description: M0 Device Startup File
; author     : jx
; data       : 07/01/2018
; (C) COPYRIGHT 2018 Shanghai Haier IC Co., Ltd.
;*******************************************************************************

;Stack Configuration------------------------------------------------------------
Stack_Size      EQU     0x00000400
                AREA    STACK, NOINIT, READWRITE, ALIGN=3
Stack_Mem       SPACE   Stack_Size
__initial_sp
;-------------------------------------------------------------------------------

;Heap Configuration-------------------------------------------------------------
Heap_Size       EQU     0x00000000
                AREA    HEAP, NOINIT, READWRITE, ALIGN=3
__heap_base
Heap_Mem        SPACE   Heap_Size
__heap_limit
;-------------------------------------------------------------------------------
                PRESERVE8
                THUMB

; Vector Table Mapped to Address 0 at Reset-------------------------------------
                AREA    RESET, DATA, READONLY
                EXPORT  __Vectors

__Vectors
                DCD     __initial_sp                    ;0,  load top of stack
                DCD     Reset_Handler                   ;1,  reset handler
                DCD     NMI_HANDLER                     ;2,  nmi handler
                DCD     HARDFAULT_HANDLER               ;3,  hard fault handler
                DCD     0                               ;4,  Reserved
                DCD     0                               ;5,  Reserved
                DCD     0                               ;6,  Reserved
                DCD     0                               ;7,  Reserved
                DCD     0                               ;8,  Reserved
                DCD     0                               ;9,  Reserved
                DCD     0                               ;10, Reserved
                DCD     SVC_HANDLER                     ;11, svcall handler
                DCD     0                               ;12, Reserved
                DCD     0                               ;13, Reserved
                DCD     PENDSV_HANDLER                  ;14, pendsv handler
                DCD     SYSTICK_HANDLER                 ;15, systick handler
                DCD     PINT0_HANDLER                   ;16, pint0 handler
                DCD     PINT1_HANDLER                   ;17, pint1 handler
                DCD     PINT2_HANDLER                   ;18, pint2 handler
                DCD     PINT3_HANDLER                   ;19, pint3 handler
                DCD     PINT4_HANDLER                   ;20, pint4 handler
                DCD     PINT5_HANDLER                   ;21, pint5 handler
                DCD     PINT6_HANDLER                   ;22, pint6 handler
                DCD     PINT7_HANDLER                   ;23, pint7 handler
                DCD     GP16C4T_HANDLER                 ;24, gp16c4t handler
                DCD     GP16C2T0_HANDLER                ;25, gp16c2t0 handler
                DCD     GP16C2T1_HANDLER                ;26, gp16c2t1 handler
                DCD     GP16C2T2_HANDLER                ;27, gp16c2t2 handler
                DCD     0                               ;28, Reserved
                DCD     AD16C4T_HANDLER                 ;29, ad16c4t  handler
                DCD     IWDT_HANDLER                    ;30, iwdt handler
                DCD     WWDT_HANDLER                    ;31, wwdt handler
                DCD     CCM_HANDLER                     ;32, ccm  handler
                DCD     PLLK_HANDLER                    ;33, pllk  handler
                DCD     LVD_HANDLER                     ;34, lvd  handler
                DCD     KINT_HANDLER                    ;35, kint handler
                DCD     AES_HANDLER                     ;36, aes handler
                DCD     ADC_HANDLER                     ;37, adc handler
                DCD     CMP_HANDLER                     ;38, cmp handler
                DCD     DMA_HANDLER                     ;39, dma handler
                DCD     UART_HANDLER                    ;40, uart handler
                DCD     SUART_HANDLER                   ;41, suart handler
                DCD     0                               ;42, Reserved
                DCD     0                               ;43, Reserved
                DCD     0                               ;44, Reserved
                DCD     SPI_HANDLER                    ;45  spi0 handler
                DCD     I2CERROR_HANDLER               ;46, i2c0error handler
                DCD     I2CEVENT_HANDLER               ;47, i2c0event handler

;-------------------------------------------------------------------------------
                ;AREA    |.text|, CODE, READONLY       ;test code begin
                AREA    INT, CODE, READONLY       ;test code begin

;Reset Handler----------------------------------------------
Reset_Handler   PROC
                EXPORT  Reset_Handler             [WEAK]
                IMPORT  __main
                LDR     R0, =__main
                BX      R0
                NOP
                ALIGN
                LTORG
                ENDP

;system int-------------------------------------------------
NMI_HANDLER     PROC                                   ;int 2
                EXPORT  NMI_HANDLER               [WEAK]
                IMPORT  INT_NMI                   [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_NMI
                POP     {PC}                           ;int exit
                ENDP

HARDFAULT_HANDLER\
                PROC                                   ;int3
                EXPORT  HARDFAULT_HANDLER         [WEAK]
                IMPORT  INT_HARDFAULT             [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_HARDFAULT
                POP     {PC}                           ;int exit
                ENDP

SVC_HANDLER     PROC                                   ;int11
                EXPORT  SVC_HANDLER               [WEAK]
                IMPORT  INT_SVC                   [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_SVC
                POP     {PC}                           ;int exit
                ENDP

PENDSV_HANDLER  PROC                                   ;int14
                EXPORT  PENDSV_HANDLER            [WEAK]
                IMPORT  INT_PENDSV                [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_PENDSV
                POP     {PC}                           ;int exit
                ENDP

SYSTICK_HANDLER PROC                                   ;int15
                EXPORT  SYSTICK_HANDLER           [WEAK]
                IMPORT  INT_SYSTICK               [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_SYSTICK
                POP     {PC}                           ;int exit
                ENDP

;pint int &peripheral module int -----------------------------------------------

PINT0_HANDLER   PROC                                   ;int16
                EXPORT  PINT0_HANDLER             [WEAK]
                IMPORT  INT_PINT0                 [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_PINT0
                POP     {PC}                           ;int exit
                ENDP

PINT1_HANDLER   PROC                                   ;int17
                EXPORT  PINT1_HANDLER             [WEAK]
                IMPORT  INT_PINT1                 [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_PINT1
                POP     {PC}                           ;int exit
                ENDP

PINT2_HANDLER   PROC                                   ;int18
                EXPORT  PINT2_HANDLER             [WEAK]
                IMPORT  INT_PINT2                 [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_PINT2
                POP     {PC}                           ;int exit
                ENDP

PINT3_HANDLER   PROC                                   ;int19
                EXPORT  PINT3_HANDLER             [WEAK]
                IMPORT  INT_PINT3                 [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_PINT3
                POP     {PC}                           ;int exit
                ENDP

PINT4_HANDLER   PROC                                   ;int20
                EXPORT  PINT4_HANDLER             [WEAK]
                IMPORT  INT_PINT4                 [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_PINT4
                POP     {PC}                           ;int exit
                ENDP

PINT5_HANDLER   PROC                                   ;int21
                EXPORT  PINT5_HANDLER             [WEAK]
                IMPORT  INT_PINT5                 [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_PINT5
                POP     {PC}                           ;int exit
                ENDP

PINT6_HANDLER   PROC                                   ;int22
                EXPORT  PINT6_HANDLER             [WEAK]
                IMPORT  INT_PINT6                 [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_PINT6
                POP     {PC}                           ;int exit
                ENDP

PINT7_HANDLER   PROC                                   ;int23
                EXPORT  PINT7_HANDLER             [WEAK]
                IMPORT  INT_PINT7                 [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_PINT7
                POP     {PC}                           ;int exit
                ENDP

GP16C4T_HANDLER   PROC                                   ;int24
                EXPORT  GP16C4T_HANDLER             [WEAK]
                IMPORT  INT_GP16C4T                 [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_GP16C4T
                POP     {PC}                           ;int exit
                ENDP

GP16C2T0_HANDLER   PROC                                   ;int25
                EXPORT  GP16C2T0_HANDLER             [WEAK]
                IMPORT  INT_GP16C2T0                 [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_GP16C2T0
                POP     {PC}                           ;int exit
                ENDP

GP16C2T1_HANDLER   PROC                                   ;int26
                EXPORT  GP16C2T1_HANDLER             [WEAK]
                IMPORT  INT_GP16C2T1                 [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_GP16C2T1
                POP     {PC}                           ;int exit
                ENDP

GP16C2T2_HANDLER   PROC                                   ;int27
                EXPORT  GP16C2T2_HANDLER             [WEAK]
                IMPORT  INT_GP16C2T2                [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_GP16C2T2
                POP     {PC}                           ;int exit
                ENDP

AD16C4T_HANDLER  PROC                                   ;int29
                EXPORT  AD16C4T_HANDLER               [WEAK]
                IMPORT  INT_AD16C4T                   [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_AD16C4T
                POP     {PC}                           ;int exit
                ENDP

IWDT_HANDLER    PROC                                   ;int30
                EXPORT  IWDT_HANDLER              [WEAK]
                IMPORT  INT_IWDT                  [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_IWDT
                POP     {PC}                           ;int exit
                ENDP

WWDT_HANDLER    PROC                                   ;int31
                EXPORT  WWDT_HANDLER              [WEAK]
                IMPORT  INT_WWDT                  [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_WWDT
                POP     {PC}                           ;int exit
                ENDP

CCM_HANDLER\
                PROC                                   ;int32
                EXPORT  CCM_HANDLER               [WEAK]
                IMPORT  INT_CCM                   [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_CCM
                POP     {PC}                           ;int exit
                ENDP

PLLK_HANDLER     PROC                                   ;int33
                EXPORT  PLLK_HANDLER               [WEAK]
                IMPORT  INT_PLLK                   [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_PLLK
                POP     {PC}                           ;int exit
                ENDP

LVD_HANDLER     PROC                                   ;int34
                EXPORT  LVD_HANDLER               [WEAK]
                IMPORT  INT_LVD                   [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_LVD
                POP     {PC}                           ;int exit
                ENDP

KINT_HANDLER    PROC                                   ;int35
                EXPORT  KINT_HANDLER              [WEAK]
                IMPORT  INT_KINT                  [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_KINT
                POP     {PC}                           ;int exit
                ENDP

AES_HANDLER     PROC                                   ;int36
                EXPORT  AES_HANDLER               [WEAK]
                IMPORT  INT_AES                   [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_AES
                POP     {PC}                           ;int exit
                ENDP

ADC_HANDLER     PROC                                   ;int37
                EXPORT  ADC_HANDLER               [WEAK]
                IMPORT  INT_ADC                   [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_ADC
                POP     {PC}                           ;int exit
                ENDP

CMP_HANDLER     PROC                                   ;int38
                EXPORT  CMP_HANDLER               [WEAK]
                IMPORT  INT_CMP                   [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_CMP
                POP     {PC}                           ;int exit
                ENDP

DMA_HANDLER     PROC                                   ;int39
                EXPORT  DMA_HANDLER               [WEAK]
                IMPORT  INT_DMA                   [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_DMA
                POP     {PC}                           ;int exit
                ENDP

UART_HANDLER\
                PROC                                   ;int40
                EXPORT  UART_HANDLER             [WEAK]
                IMPORT  INT_UART                 [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_UART
                POP     {PC}                           ;int exit
                ENDP

SUART_HANDLER\
                PROC                                   ;int41
                EXPORT  SUART_HANDLER             [WEAK]
                IMPORT  INT_SUART                 [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_SUART
                POP     {PC}                           ;int exit
                ENDP

SPI_HANDLER\
                PROC                                   ;int45
                EXPORT  SPI_HANDLER             [WEAK]
                IMPORT  INT_SPI                 [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_SPI
                POP     {PC}                           ;int exit
                ENDP

I2CERROR_HANDLER\
                PROC                                   ;int46
                EXPORT  I2CERROR_HANDLER              [WEAK]
                IMPORT  INT_I2CERROR                  [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_I2CERROR
                POP     {PC}                           ;int exit
                ENDP

I2CEVENT_HANDLER\
                PROC                                   ;int47
                EXPORT  I2CEVENT_HANDLER              [WEAK]
                IMPORT  INT_I2CEVENT                  [WEAK]
                PUSH    {LR}                           ;protect exc_return
                BL      INT_I2CEVENT
                POP     {PC}                           ;int exit
                ENDP


 ;User Initial Stack & Heap-----------------------------------------------------
                ALIGN
                IF      :DEF:__MICROLIB

                EXPORT  __initial_sp
                EXPORT  __heap_base
                EXPORT  __heap_limit

                ELSE

                IMPORT  __use_two_region_memory
                EXPORT  __user_initial_stackheap
__user_initial_stackheap
                LDR     R0, =  Heap_Mem
                LDR     R1, = (Stack_Mem + Stack_Size)
                LDR     R2, = (Heap_Mem +  Heap_Size)
                LDR     R3, = Stack_Mem
                BX      LR

                ALIGN

                ENDIF
                ALIGN
                END
