;*******************************************************************************
; *file       : startup_es32f0930.s
; *description: ES32F0930 Device Startup File
; *author     : Eastsoft MCU Software Team
; *version    : V0.01
; *data       : 12/10/2018
;
; *Copyright (C) 2018 Shanghai Eastsoft Microelectronics Co., Ltd.
; *
; * THIS SOFTWARE IS PROVIDED "AS IS".  NO WARRANTIES, WHETHER EXPRESS, IMPLIED
; * OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
; * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE.
; * ARM SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL, OR
; * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
;*******************************************************************************


; <h> Stack Configuration
;   <o> Stack Size (in Bytes) <0x0-0xFFFFFFFF:8>
; </h>

Stack_Size      EQU     0x00000400

                AREA    STACK, NOINIT, READWRITE, ALIGN=3
Stack_Mem       SPACE   Stack_Size
__initial_sp


; <h> Heap Configuration
;   <o>  Heap Size (in Bytes) <0x0-0xFFFFFFFF:8>
; </h>

Heap_Size       EQU     0x00000000

                AREA    HEAP, NOINIT, READWRITE, ALIGN=3
__heap_base
Heap_Mem        SPACE   Heap_Size
__heap_limit


                PRESERVE8
                THUMB


; Vector Table Mapped to Address 0 at Reset

                AREA    RESET, DATA, READONLY
                EXPORT  __Vectors

__Vectors       DCD     __initial_sp               ; Top of Stack
                DCD     Reset_Handler              ;1, Reset Handler
                DCD     NMI_Handler                ;2, NMI Handler
                DCD     HARDFAULT_Handler          ;3, HARDFAULT Handler
                DCD     0                          ;4, Reserved
                DCD     0                          ;5, Reserved
                DCD     0                          ;6, Reserved
                DCD     0                          ;7, Reserved
                DCD     0                          ;8, Reserved
                DCD     0                          ;9, Reserved
                DCD     0                          ;10, Reserved
                DCD     SVC_Handler                ;11, SVC Handler
                DCD     0                          ;12, Reserved
                DCD     0                          ;13, Reserved
                DCD     PENDSV_Handler             ;14, PENDSV Handler
                DCD     SYSTICK_Handler            ;15, SYSTICK Handler
                ; External Interrupts
                DCD     WWDG_IRQHandler            ;16, WWDG IRQHandler
                DCD     PVD_IRQHandler             ;17, PVD IRQHandler
                DCD     0                          ;18, Reserved
                DCD     WAKEUP_IRQHandler					 ;19, WAKEUP IRQHandler
                DCD     RCU_IRQHandler             ;20, RCU IRQHandler
                DCD     EXTI0_1_IRQHandler         ;21, EXTI01_1 IRQHandler
                DCD     EXTI2_3_IRQHandler         ;22, EXTI2_3 IRQHandler
                DCD     EXTI4_15_IRQHandler        ;23, EXTI4_15 IRQHandler
                DCD     0                          ;24, Reserved
                DCD     0                          ;25, Reserved
                DCD     LCD_IRQHandler      			 ;26, LCD IRQHandler
                DCD     DMM_IRQHandler      			 ;27, DMM IRQHandler
                DCD     EXTI_16to19_IRQHandler     ;28, EXTI_16to19 IRQHandler
                DCD     0                          ;29, Reserved
                DCD     BS16T1_IRQHandler          ;30, BS16T1 IRQHandler
                DCD     GP32C4T1_IRQHandler        ;31, GP32C4T1 IRQHandler
                DCD     0                          ;32, Reserved
                DCD     0                          ;33, Reserved
                DCD     0                          ;34, Reserved
                DCD     GP16C2T1_IRQHandler        ;35, GP16C2T1 IRQHandler
                DCD     GP16C2T2_IRQHandler        ;36, GP16C2T2 IRQHandler
                DCD     0                          ;37, Reserved
                DCD     0                          ;38, Reserved
                DCD     I2C1_IRQHandler            ;39, I2C1 IRQHandler
                DCD     0                          ;40, Reserved
                DCD     SPI1_IRQHandler            ;41, SPI1 IRQHandler
                DCD     0                          ;42, Reserved
                DCD     UART1_IRQHandler           ;43, UART1 IRQHandler
                DCD     0                          ;44, Reserved
                DCD     0                          ;45, Reserved
                DCD     SUART1_IRQHandler   			 ;46, SUART1 IRQHandler
                DCD     0                          ;47, Reserved


                AREA    |.text|, CODE, READONLY


; Reset Handler

Reset_Handler   PROC
                EXPORT  Reset_Handler             [WEAK]
                IMPORT  __main
                IMPORT  SystemInit
                LDR     R0, =SystemInit
                BLX     R0
                LDR     R0, =__main
                BX      R0
                ENDP

; Dummy Exception IRQHandlers (infinite loops which can be modified)

NMI_Handler      PROC
            EXPORT  NMI_Handler            [WEAK]
            B       .
            ENDP
HARDFAULT_Handler      PROC
            EXPORT  HARDFAULT_Handler            [WEAK]
            B       .
            ENDP


SVC_Handler      PROC
            EXPORT  SVC_Handler          [WEAK]
            B       .
            ENDP

PENDSV_Handler      PROC
            EXPORT  PENDSV_Handler       [WEAK]
            B       .
            ENDP
SYSTICK_Handler      PROC
            EXPORT  SYSTICK_Handler      [WEAK]
            B       .
            ENDP

Default_Handler PROC



                EXPORT  WWDG_IRQHandler			[WEAK]
                EXPORT  PVD_IRQHandler			[WEAK]
                EXPORT  WAKEUP_IRQHandler		[WEAK]
                EXPORT  RCU_IRQHandler  		[WEAK]
                EXPORT  EXTI0_1_IRQHandler	[WEAK]
                EXPORT  EXTI2_3_IRQHandler	[WEAK]
                EXPORT  EXTI4_15_IRQHandler	[WEAK]
                EXPORT  LCD_IRQHandler    	[WEAK]
                EXPORT  DMM_IRQHandler    	[WEAK]
                EXPORT  EXTI_16to19_IRQHandler	[WEAK]
                EXPORT  BS16T1_IRQHandler		[WEAK]
                EXPORT  GP32C4T1_IRQHandler	[WEAK]
                EXPORT  GP16C2T1_IRQHandler	[WEAK]
                EXPORT  GP16C2T2_IRQHandler	[WEAK]
                EXPORT  I2C1_IRQHandler			[WEAK]
                EXPORT  SPI1_IRQHandler			[WEAK]
                EXPORT  UART1_IRQHandler		[WEAK]
                EXPORT  SUART1_IRQHandler		[WEAK]



WWDG_IRQHandler
PVD_IRQHandler
WAKEUP_IRQHandler
RCU_IRQHandler
EXTI0_1_IRQHandler
EXTI2_3_IRQHandler
EXTI4_15_IRQHandler
LCD_IRQHandler
DMM_IRQHandler
EXTI_16to19_IRQHandler
BS16T1_IRQHandler
GP32C4T1_IRQHandler
GP16C2T1_IRQHandler
GP16C2T2_IRQHandler
I2C1_IRQHandler
SPI1_IRQHandler
UART1_IRQHandler
SUART1_IRQHandler


                B       .

                ENDP

                ALIGN

; User Initial Stack & Heap

                IF      :DEF:__MICROLIB

                EXPORT  __initial_sp
                EXPORT  __heap_base
                EXPORT  __heap_limit

                ELSE

                IMPORT  __use_two_region_memory
                EXPORT  __user_initial_stackheap

__user_initial_stackheap

                LDR     R0, =  Heap_Mem
                LDR     R1, =(Stack_Mem + Stack_Size)
                LDR     R2, = (Heap_Mem +  Heap_Size)
                LDR     R3, = Stack_Mem
                BX      LR

                ALIGN

                ENDIF

                END


