/**
  ******************************************************************************
  * @file    ald_rtchw.h
  * @brief   Header file of RTCHW Module driver.
  *
  * @version V1.0
  * @date    16 Nov 2017
  * @author  AE Team
  * @note
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *******************************************************************************
  */

#ifndef __ALD_RTCHW_H__
#define __ALD_RTCHW_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "utils.h"
#include "ald_rtc.h"


/** @addtogroup ES32FXXX_ALD
  * @{
  */

/** @addtogroup RTCHW
  * @{
  */

/** @defgroup RTCHW_Public_Types RTC Public Types
  * @{
  */

/**
  * @brief Hardware calibration algorithm
  */
typedef enum {
	RTC_CALI_MODE_NORMAL = 0,	/**< Normal mode */
	RTC_CALI_MODE_SLEEP  = 1,	/**< Low power mode */
} rtc_hw_cali_mode_t;

/**
  * @brief the parameters table of rtc calibration
  */
typedef  struct {
	uint32_t  MODE_CALI;
	uint32_t  RTC_CALCR;
	uint32_t  RTC_TEMPBDR;
	uint32_t  TEMP_TBDR;
	uint32_t  RTC_LTCAR;
	uint32_t  RTC_LTCBR;
	uint32_t  RTC_LTCCR;
	uint32_t  RTC_LTCDR;
	uint32_t  RTC_HTCAR;
	uint32_t  RTC_HTCBR;
	uint32_t  RTC_HTCCR;
	uint32_t  RTC_HTCDR;
	uint32_t  TEMP_LTGR;
	uint32_t  TEMP_HTGR;
	uint32_t  TEMP_CR;
	uint32_t  rsv0;
	uint32_t  RTC_LTCER;
	uint32_t  RTC_HTCER;
	uint32_t  TEMP_PEAK;
	uint32_t  FREQ_PEAK;
	uint32_t  TEMP_CALI;
	uint32_t  TEMP_CALI_AFTER;
	uint32_t  TEMP_TCALBDR;
	uint32_t  TEMP_TCALBDR_MINUS;
	uint32_t  rsv1[6];
	uint32_t  SUM;
	uint32_t  SUM_MINUS;
} RTCINFO_TypeDef;

#define RTCINFO	((RTCINFO_TypeDef *)0x41000)

/**
  * @brief Hardware calibration structure
  */
typedef struct {
	int16_t  offset_rtc_bdr;	/**< offset:0x00 */
	int16_t  offset_temp_bdr;	/**< offset:0x02 */
	int16_t  offset_ltcar;		/**< offset:0x04 */
	int16_t  offset_ltcbr;		/**< offset:0x06 */
	int16_t  offset_ltccr;		/**< offset:0x08 */
	int16_t  offset_ltcdr;		/**< offset:0x0A */
	int16_t  offset_htcar;		/**< offset:0x0C */
	int16_t  offset_htcbr;		/**< offset:0x0E */
	int16_t  offset_htccr;		/**< offset:0x10 */
	int16_t  offset_htcdr;		/**< offset:0x12 */
	int16_t  offset_ltgr;		/**< offset:0x14 */
	int16_t  offset_htgr;		/**< offset:0x16 */
	int16_t  offset_ltcer;		/**< offset:0x18 */
	int16_t  offset_htcer;		/**< offset:0x1A */
	int16_t  offset_temp_peak;	/**< offset:0x1C */
	int16_t  offset_freq_peak;	/**< offset:0x1E */
	int16_t  offset_tcalbdr;	/**< offset:0x20 */
	int16_t  crc;                   /**< offset:0x22 */
	int16_t  rsv[10];
} rtc_hw_cali_offset_t;

/**
  * @}
  */

/** @addtogroup RTC_Public_Functions
  * @{
  */

/* Calibration functions */
void rtc_hw_auto_cali(rtc_hw_cali_offset_t *config, rtc_hw_cali_mode_t mode);
/**
  * @}
  */
/**
  * @}
  */
/**
  * @}
  */
#ifdef __cplusplus
}
#endif
#endif
