/**
  *********************************************************************************
  *
  * @file    hal_syscfg.h
  * @brief   SYSCFG module driver.
  *
  * @version V1.0
  * @date    04 Jun 2017
  * @author  AE Team
  * @note
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  *********************************************************************************
  */

#ifndef __HAL_SYSCFG_H__
#define __HAL_SYSCFG_H__

#ifdef __cplusplus
 extern "C" {
#endif

#include "utils.h"


/** @addtogroup ES32FXXX_HAL
  * @{
  */

/** @defgroup SYSCFG SYSCFG
  * @{
  */

/** @defgroup SYSCFG_Public_Macros SYSCFG Public Macros
  * @{
  */
#define SYSCFG_LOCK()  		(SYSCFG->PROT.KEY = 0x0)
#define SYSCFG_UNLOCK()		(SYSCFG->PROT.KEY = 0x55AA6996)
#define GET_SYSCFG_LOCK()	(SYSCFG->PROT.Word & 0x01)

#define BOOT_FROM_BOOT_ROM()		\
do {					\
	SYSCFG_UNLOCK();		\
	SYSCFG->MEMRMP.BRRMPEN = 1	\
	SYSCFG->MEMRMP.BFRMPEN = 0	\
	SYSCFG_LOCK();			\
} while (0)
#define BOOT_FROM_FLASH()		\
do {					\
	SYSCFG_UNLOCK();		\
	SYSCFG->MEMRMP.BRRMPEN = 0	\
	SYSCFG->MEMRMP.BFRMPEN = 1	\
	SYSCFG_LOCK();			\
} while (0)
/**
  * @}
  */


/** @defgroup SYSCFG_Public_Functions SYSCFG Public Functions
  * @{
  */
__inline void vtor_config(uint32_t offset, type_func_t status)
{
	SYSCFG_UNLOCK();

	if (status) {
		SYSCFG->MEMRMP.VTOEN = 1;
		SYSCFG->VTOR.VTO     = (offset & ~0x3F);
	}
	else {
		SYSCFG->MEMRMP.VTOEN = 0;
	}

	SYSCFG_LOCK();
	return;
}
/**
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */

#ifdef __cplusplus
}
#endif

#endif
